# S[hEBhE(S)
# Authors:: fukuyama
# Date:: 2012/01/30
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  class Window_Status_Gold < ::Window_Base
    include Window_Tree_Module
    # IuWFNg
    def initialize(parent)
      w = CHARA_WIDTH * 11 + standard_padding * 2
      lines = 2
      @bank = Script_Config.variable('s',nil)
      if not @bank.nil?
        lines += 1
      end
      h = fitting_height(lines)
      super(parent,0,0,w,h)
      refresh
    end

    # `
    def refresh
      self.contents.clear
      rect = self.contents.rect
      rect.height = line_height
      self.contents.draw_text(rect, '', 1)
      draw_gold(1)
      draw_bank(2)
    end

    def draw_parameter(x,y,key,val,ak=2,av=2)
      key += ':'
      wk = text_size(key).width + 4
      wv = self.contents.width - wk
      change_color(system_color)
      draw_text(x, y, wk, line_height, key, ak)
      change_color(normal_color)
      draw_text(x + wk, y, wv, line_height, val, av)
    end

    def draw_gold(i)
      key = '傶'
      val = $game_party.gold.to_s + ' ' + Vocab.currency_unit()
      draw_parameter(0,line_height * i,key,val)
    end

    def draw_bank(i)
      return unless @bank
      key = '񂱂'
      val = @bank.to_s + ' ' + Vocab.currency_unit()
      draw_parameter(0,line_height * i,key,val)
    end

  end

end
