# }bvXLXe[^XEBhE
# Authors:: fukuyama
# Date:: 2012/02/06
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  class Window_Status_Normal_Skill < ::DQ::Window_Command_Base
    include Window_Tree_Module
    include Window_Command_Title_Module
    # 
    def initialize(parent)
      self.title = Vocab::MenuSkillStatusTitle
      self.title_align = 1
      super(parent,0,0)
      self.top = parent.top + 32
      self.right = parent.right - 32
      self.unselect()
    end

    # j[̕
    def menu_width
      CHARA_WIDTH * 5
    end

    # ڂ̑I𖳌
    def select(index)
    end

    # ڂ̗L true
    def current_item_enabled?
      true
    end

    # AN^[̎擾
    def actor
      self.parent.actor
    end

    # R}hXg̍쐬
    # AN^[XL̍XV
    def make_command_list
      self.actor.class.learnings.collect() do |l|
        $data_skills[l.skill_id]
      end.select() do |s|
        s.menu_ok?
      end.each() do |skill|
        add_command(skill.name, :ok, true, skill)
      end
    end

    # 菈
    def ok
      parent.close
    end

    # ڂ̕`
    def draw_item(index)
      skill = @list[index][:ext]
      if self.actor.skill_learn?(skill)
        change_color(normal_color)
        draw_text(item_rect_for_text(index), command_name(index), alignment)
      end
    end
  end

end
