# VbvEBhE
# Authors:: fukuyama
# Date:: 2012/05/02
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  class Window_Shop < ::DQ::Window_Command_Base
    include Window_Tree_Module
    def initialize(shop_goods,price_rate = 100)
      @price_rate = price_rate
      @shop_goods = shop_goods
      @money = $game_party.gold
      super(nil,16,16)
      self.z = 300

      gold_window = Window_Gold.new
      gold_window.right = Graphics.width - 16
      gold_window.top = 16
      add_child(gold_window)

      @status = Window_Shop_Actor_Status.new(self)
      add_child(@status)

      # ACewvEBhE쐬
      help_window = Window_Help.new(WINDOW_ITEM_HELP_LINE_NUMBER)
      help_window.width = gold_window.right - self.right
      help_window.create_contents
      help_window.top = gold_window.bottom
      help_window.left = self.right
      help_window.hide
      add_child(help_window)
      self.help_window = help_window

      @interpreter = nil
    end

    # R}hXg̍쐬
    def make_command_list
      make_item_list
      @data.each do |item|
        add_command(item.name, :select_item, true, item)
      end
    end

    # ACeXg̍쐬
    def make_item_list
      @data = []
      @price = {}
      @shop_goods.each do |goods|
        case goods[0]
        when 0;  item = $data_items[goods[1]]
        when 1;  item = $data_weapons[goods[1]]
        when 2;  item = $data_armors[goods[1]]
        end
        if item
          @data.push(item)
          @price[item] = ((goods[2] == 0 ? item.price : goods[3]) * (@price_rate.to_f / 100.0)).to_i
        end
      end
    end

    def current_item_enabled?
      enable?(@data[index])
    end

    # j[J
    def col_max
      return 1
    end

    # j[̕\s
    def visible_line_number
      6
    end

    # j[̕
    def menu_width
      CHARA_WIDTH * 15
    end

    # ACe̎擾
    def item
      return current_ext
    end

    def select_item
      if price(item) > @money
        return
      end
      close
    end

    def cancel
      self.index = -1 
      close
    end

    # i̒li擾
    def price(item)
      @price[item]
    end

    # ACeԂŕ\邩ǂ
    def enable?(item)
      item && price(item) <= @money && !$game_party.item_max?(item)
    end

    # ڂ̕`
    def draw_item(index)
      item = @data[index]
      rect = item_rect(index)
      draw_item_name(item, rect.x, rect.y, enable?(item))
      rect.width -= 4
      draw_text(rect, price(item).to_s + ' ' + Vocab::currency_unit, 2)
    end

    def update_help
      return if self.help_window.disposed?
      self.help_window.show if not self.help_window.visible
      if not self.item.nil?
        @status.set_item(item)
        self.help_window.set_text(self.item.description.dup)
      else
        self.help_window.set_text('')
      end
    end

  end

end
