# ACe𔃂̃AN^[Xe[^XEBhE(Window_Shop_Actor_Status)
# Authors:: fukuyama
# Date:: 2012/05/04
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  class Window_Shop_Actor_Status < ::Window_Base
    include Window_Tree_Module
    # 
    def initialize(parent)
      @actors = $game_party.members

      # RecWvZ
      w = parent.width
      h = fitting_height(@actors.size + 2)
      x = parent.left
      y = parent.bottom
      super(parent,x,y,w,h)
      @item = nil

      # \WvZ
      @iw = text_size('0').width * 4
      @cw = text_size('').width
      @bx = contents.width - @iw - 2
      @cx = @bx - @cw
      @ax = @cx - @iw - 2
    end

    # ACeݒ
    def set_item(item)
      if @item != item
        @item = item
        refresh
      end
    end

    # ĕ`
    def refresh
      self.contents.clear
      self.contents.font.color = normal_color
      if Item_Facade.item?(@item)
        refresh_item
        refresh_backpack(Game_Item)
      elsif Item_Facade.weapon?(@item)
        refresh_weapon
        refresh_backpack(Game_Weapon)
      elsif Item_Facade.armor?(@item)
        refresh_armor
        refresh_backpack(Game_Armor)
      end
    end

    # ^Cg
    def draw_title(title)
      w = self.contents.width
      h = line_height
      x,y = 0,0
      self.contents.draw_text(x,y,w,h,title,1)
      y += h
    end

    # Xe[^X
    def draw_equip_status(index,a,b)
      y = index * line_height + line_height
      self.contents.draw_text(@ax, y, @iw, line_height, a.to_s, 2)
      self.contents.draw_text(@cx, y, @cw, line_height, '',   0)
      self.contents.draw_text(@bx, y, @iw, line_height, b.to_s, 2)
    end

    # s
    def draw_no_equip_status(index)
      y = index * line_height + line_height
      self.contents.draw_text(0,y,self.contents.width,line_height,'тłȂ',2)
    end

    # AN^[
    def draw_actor_name(index,actor)
      y = index * line_height + line_height
      self.contents.draw_text(0,y,self.contents.width,line_height,actor.name,0)
    end

    # Xe[^X
    def draw_item_status(index,text)
      y = index * line_height + line_height
      self.contents.draw_text(0,y,self.contents.width,line_height,text,2)
    end

    # 
    def draw_item_count(index,actor,klass)
      y = index * line_height + line_height
      count = actor.backpack.item_count_by_id(klass,@item.id)
      if count != 0
        text  = "#{count} "
        self.contents.draw_text(0,y,self.contents.width,line_height,text,1)
      end
    end

    # ̕\
    def refresh_item
      # ^Cg
      draw_title('ǂ')

      @actors.each_index do |index|
        actor = @actors[index]

        # AN^[
        draw_actor_name(index,actor)

        count = actor.backpack.item_count_by_id(Game_Item,@item.id)
        if 0 < count
          draw_item_status(index,'Ă')
        else
          draw_item_status(index,'ĂȂ')
        end
        draw_item_count(index,actor,Game_Item)
      end
    end

    # ̕\
    def refresh_weapon
      # ^Cg
      draw_title(Vocab::param(2))
      @actors.each_index do |index|
        actor = @actors[index]

        # AN^[
        draw_actor_name(index,actor)

        if actor.equippable?(@item)
          # łꍇ
          (a,b) = actor.equip_new_param(@item,2)
          draw_equip_status(index,a,b)
        else
          # łȂꍇ
          draw_no_equip_status(index)
        end
        draw_item_count(index,actor,Game_Weapon)
      end
    end

    # h̕\
    def refresh_armor
      # ^Cg
      draw_title(Vocab::param(3))

      @actors.each_index do |index|
        actor = @actors[index]

        # AN^[
        draw_actor_name(index,actor)

        if actor.equippable?(@item)
          # łꍇ
          (a,b) = actor.equip_new_param(@item,3)
          draw_equip_status(index,a,b)
        else
          # łȂꍇ
          draw_no_equip_status(index)
        end
        draw_item_count(index,actor,Game_Armor)
      end
    end

    # ӂ̕\
    def refresh_backpack(klass)
      index = (@actors.size)
      y = index * line_height + line_height
      self.contents.draw_text(0,y,self.contents.width,line_height,'ӂ̂Ȃ',0)
      count = $game_party.backpack.item_count_by_id(klass,@item.id)
      if 0 < count
        draw_item_status(index,'͂Ă')
      else
        draw_item_status(index,'͂ĂȂ')
      end
      draw_item_count(index,$game_party,klass)
    end
  end

end
