# 䕶W[
# Authors:: fukuyama
# Date:: 2011/12/15
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module Process_Character_Module
  # 䕶̃Xg
  PROCESS_CHARACTERS = []
  # 䕶̊NX
  class ProcessBase
    # 䕶R[h
    attr_reader :code
    # IvV
    attr_reader :options
    # 
    # code:: 䕶R[h(String)
    # options:: IvViHashj
    def initialize(code,options={})
      @code = code.upcase
      @options = options
    end

    # 䕶s
    def process(obj,txt,pos)
    end
  end

  # NX\bh
  # `ꂽ\bh include NX extend 邽߂̃W[
  module ClassMethods
    def add_process_character(code,op={},&block)
      PROCESS_CHARACTERS.push(Class.new(ProcessBase,&block).new(code,op))
    end
  end

  # W[ include ꂽ̏
  # NX\bh@extend 
  def self.included(klass)
    klass.extend(ClassMethods)
  end
end

# EBhEx[X
class Window_Base
  include Process_Character_Module
  # 䕶̖{̂jIɎ擾
  # FIXME:: IWiύX̂Ŗ肪邩ȂB
  def obtain_escape_code(text)
    text.slice!(/^[\$\.\|\^!><\{\}\\]|^[A-Z][A-Z._]*/i)
  end

  # 䕶̈jIɎ擾
  # FIXME:: IWiύX̂Ŗ肪邩ȂB
  def obtain_escape_param(text)
    begin
      params = text.slice!(/^\[[^\]]+?\]/)[/[^\[\]]+/]
      params = params.split(/,/).collect() do |param|
        if param =~ /^\d+$/
          param.to_i
        else
          param
        end
      end
      return params.size == 1 ? params[0] : params
    rescue
      return nil
    end
  end

  # Ŏ擾
  def obtain_escape_param_string(text)
    begin
      return text.slice!(/^\[[^\]]+?\]/)[/[^\[\]]+/]
      params = params.split(/,/)
      return params.size == 1 ? params[0] : params
    rescue
      return nil
    end
  end

  # ̃XgŎ擾
  def obtain_escape_param_strings(text)
    begin
      params = text.slice!(/^\[[^\]]+?\]/)[/[^\[\]]+/].split(/,/)
      return params
    rescue
      return nil
    end
  end

  # 䕶̏
  # code:: 䕶̖{̕iu\C[1]vȂuCvj
  def process_escape_character(code, text, pos)
    PROCESS_CHARACTERS.each() do |o|
      if code.upcase == o.code
        o.process(self, text, pos)
      end
    end
  end

  add_process_character('C') do
    def process(w,txt,pos)
      w.change_color(w.text_color(w.obtain_escape_param(txt)))
    end
  end
  add_process_character('I') do
    def process(w,txt,pos)
      w.process_draw_icon(w.obtain_escape_param(txt), pos)
    end
  end
  add_process_character('{') do
    def process(w,txt,pos)
      w.make_font_bigger
    end
  end
  add_process_character('}') do
    def process(w,txt,pos)
      w.make_font_smaller
    end
  end
end
