# Sprite_Page_Arrow
# Authors:: fukuyama
# Date:: 2012/03/24
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  # A[^CvJ[\NX
  class Sprite_Page_Arrow < ::Sprite
    # 
    def initialize(name,viewport)
      super(viewport)
      self.bitmap = Script_Bitmap["#{name}_arrow"]
    end
  end

  # EA[J[\
  class Sprite_Page_Right_Arrow < Sprite_Page_Arrow
    # 
    def initialize(viewport)
      super('right',viewport)
    end
  end

  # A[J[\
  class Sprite_Page_Left_Arrow < Sprite_Page_Arrow
    # 
    def initialize(viewport)
      super('left',viewport)
    end
  end

  module Sprite_Page_Arrow_Module
    # 
    def initialize(*arg)
      super(*arg)
      @sprite_page_right_arrow = Sprite_Page_Right_Arrow.new(self.viewport)
      @sprite_page_left_arrow = Sprite_Page_Left_Arrow.new(self.viewport)
      update_page_arrow
    end

    # j
    def dispose
      super
      @sprite_page_right_arrow.dispose
      @sprite_page_left_arrow.dispose
    end

    def index=(i)
      super(i)
      update_page_arrow
    end
    def z=(z)
      super(z)
      @sprite_page_right_arrow.z = z + 2
      @sprite_page_left_arrow.z = z + 2
    end

    # A[J[\̍XV
    def update_page_arrow
      return if @sprite_page_right_arrow.nil? or @sprite_page_left_arrow.nil?
      if page_item_max < item_max
        if index < page_item_max
          @sprite_page_right_arrow.visible = true
          @sprite_page_right_arrow.z = self.z + 2
          @sprite_page_right_arrow.x = self.x + self.width - @sprite_page_right_arrow.src_rect.width
          @sprite_page_right_arrow.y = self.y + self.height - @sprite_page_right_arrow.src_rect.height
          #          @sprite_page_right_arrow.update
        else
          @sprite_page_right_arrow.visible = false
        end
        if page_item_max <= index
          @sprite_page_left_arrow.visible = true
          @sprite_page_left_arrow.z = self.z + 2
          @sprite_page_left_arrow.x = self.x
          @sprite_page_left_arrow.y = self.y + self.height - @sprite_page_left_arrow.src_rect.height
          #          @sprite_page_left_arrow.update
        else
          @sprite_page_left_arrow.visible = false
        end
      else
        @sprite_page_right_arrow.visible = false
        @sprite_page_left_arrow.visible = false
      end
    end

    # \
    def visible=(v)
      super(v)
      unless v
        @sprite_page_right_arrow.visible = v
        @sprite_page_left_arrow.visible = v
      end
    end

  end

end
