# DQ ̃EBhER}hx[X
# Authors:: fukuyama
# Date:: 2011/12/15
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module DQ
  # DQ ̃EBhER}hx[X
  class Window_Command_Base < ::Window_Command
    include Sprite_Page_Arrow_Module
    # 
    def initialize(x, y)
      super(x, y)
      set_handlers()
      self.arrows_visible = false
      scene = SceneManager.scene
      if @interpreter.nil? and scene.respond_to?(:interpreter)
        @interpreter = scene.interpreter
      end
    end

    # J[\ʒu̐ݒ
    def index=(index)
      super
      call_change_index_handler
    end

    # J[\ʒuύXꂽ̃nh
    def call_change_index_handler
      call_handler(:change_index)
    end

    # nh[ݒ
    def set_handlers()
      # ǉĂR}hɃnhݒ肷
      @list.each() do |command|
        symbol = command[:symbol]
        if respond_to?(symbol) and not handle?(symbol)
          set_handler(symbol, method(symbol))
        end
      end
      # LZnhݒ肳Ėꍇ
      if not handle?(:cancel)
        if respond_to?(:cancel)
          # LZ\bh΁Aݒ
          set_handler(:cancel, method(:cancel))
        else
          # Ȃ΁Aclose ݒiftHgN[YɁj
          set_handler(:cancel, method(:close))
        end
      end
      # CfbNXύXnh
      if respond_to?(:change_index) and not handle?(:change_index)
        set_handler(:change_index, method(:change_index))
      end
    end

    # ɍڂԂƂ̋󔒂̕擾
    def spacing
      return 2
    end

    # EBhE̕
    def window_width
      # 12 ̓eLXgj[pXy[X
      return (menu_width + spacing + 12) * col_max - spacing + standard_padding * 2
    end

    # j[̕\s
    def visible_line_number
      n = super
      c = col_max()
      (n + n % c) / c
    end

    # j[̌̕vZ
    def menu_width
      bmp = Bitmap.new(Graphics.width,line_height())
      max_width = 0
      @list.each() do |command|
        max_width = [max_width,bmp.text_size(command[:name]).width].max
      end
      bmp.dispose
      return max_width
    end

    # XV
    def update
      if not @interpreter.nil? and @interpreter.running?
        return
      end
      super
    end

    # eXgp
    def unsupport
      msg  = "܂Ă܂B"
      scene = SceneManager.scene
      if scene.respond_to?(:interpreter)
        e = Script_Event.new
        e.message(msg)
        e.blank
        SceneManager.scene.interpreter.setup(e.event_commands)
      else
        p msg if $TEST
      end
    end

    # ݂̃y[Wɕ\Ă鐔
    def current_page_item_num
      page_item = page_item_max
      page_item = item_max % page_item_max if index + (item_max % page_item) >= item_max
      return page_item
    end

    # Py[W̃ACe𔠌^ɂꍇ̌
    def page_item_box_num
      page_item = current_page_item_num
      if index % col_max < page_item % col_max
        page_item += col_max - page_item % col_max
      else
        page_item -= page_item % col_max
      end
    end

    # J[\Ɉړ
    def cursor_down(wrap = false)
      next_page_row = (row + 1) % [page_row_max,row_max].min
      if (next_page_row == 0 or (index + col_max) >= item_max) and wrap
        select((index + col_max - page_item_box_num + item_max) % item_max)
      elsif next_page_row != 0 and (index + col_max) < item_max
        select((index + col_max + item_max) % item_max)
      end
    end

    # J[\Ɉړ
    def cursor_up(wrap = false)
      current_page_row = row % [page_row_max,row_max].min
      if current_page_row == 0 and wrap
        select((index - col_max + page_item_box_num + item_max) % item_max)
      elsif current_page_row != 0 and (index - col_max) >= 0
        select((index - col_max + item_max) % item_max)
      end
    end

    # J[\EɈړ
    def cursor_right(wrap = false)
      next_page_col = (index + 1) % col_max
      if next_page_col == 0 and top_row + page_row_max < row_max
        self.top_row += page_row_max
        select([(index + page_item_max - col_max + 1),item_max - 1].min)
      elsif col_max >= 2 and ((index < item_max - 1 and next_page_col != 0) or (wrap and horizontal?))
        select((index + 1) % item_max)
      elsif col_max >= 2 and next_page_col == 0 and item_max <= page_item_max and wrap
        select((index + 1 - col_max + item_max) % item_max)
      end
    end

    # J[\Ɉړ
    def cursor_left(wrap = false)
      current_page_col = index % col_max
      if current_page_col == 0 and top_row > 0
        self.top_row -= page_row_max
        select([(index - page_item_max + col_max - 1),0].max)
      elsif col_max >= 2 and (current_page_col != 0 or (wrap and horizontal?))
        select((index - 1 + item_max) % item_max)
      elsif col_max >= 2 and current_page_col == 0 and item_max <= page_item_max and wrap
        select((index - 1 + col_max + item_max) % item_max)
      end
    end

  end
end
