# -*- coding: sjis -*-
# XCb`W[eXg
# Authors:: fukuyama
# Date:: 2011/12/21
# Copyright:: Copyright (c) 2011 rgss-lib

require 'Win32API'
require 'kconv'
require 'test/unit'
require 'debug/debug_base'
require 'debug/default_require'
require 'common/Switches'

class Switches_Test < Test::Unit::TestCase
  def setup
    Debug.create_normal_database
    DataManager.create_game_objects
    $data_system.switches[1] = 'DEF'
    $data_system.switches[2] = 'XXX'
    Switches.init
    Switches[1] = true
  end

  def test_switche_01
    assert_equal(true,Switches[1])
    assert_equal(false,Switches[2])
    assert_equal(true,Switches['DEF'])
    assert_equal(false,Switches['ABC'])
    assert_equal(false,Switches[999])
    assert_equal(false,Switches['XXX'])
  end

  def test_switche_02
    assert_equal(true,Switches[1,true])
    assert_equal(false,Switches[2,true])
    assert_equal(true,Switches[3,true])
    assert_equal(true,Switches['DEF',true])
    assert_equal(true,Switches['DEF',false])
    assert_equal(true,Switches['ABC',true])
    assert_equal(false,Switches['ABC',false])
    assert_equal(false,Switches['XXX',true])
  end

  def test_switche_03
    assert_equal(true,Switches[1])
    assert_equal(false,Switches[1] = false)
    assert_equal(false,Switches[1])
    Switches[1] = true
    assert_equal(true,Switches[1])
    assert_equal(false,Switches['XXX'])
    assert_equal(true,Switches['XXX'] = true)
    assert_equal(true,Switches['XXX'])
    Switches['XXX'] = false
    assert_equal(false,Switches['XXX'])

    Switches[999] = true
    assert_equal(false,Switches[999])
    Switches['ABC'] = true
    assert_equal(false,Switches['ABC'])
  end

  def test_include?
    assert_equal(false,Switches.include?('ABC'))
    assert_equal(true,Switches.include?('DEF'))
    assert_equal(false,Switches.include?(0))
    assert_equal(true,Switches.include?(1))
    assert_equal(true,Switches.include?(2))
    assert_equal(false,Switches.include?(3))
  end

  def test_index
    assert_equal(-1,Switches.index('ABC'))
    assert_equal(1,Switches.index('DEF'))
    assert_equal(-1,Switches.index(0))
    assert_equal(1,Switches.index(1))
    assert_equal(2,Switches.index(2))
    assert_equal(-1,Switches.index(3))
    assert_equal(-1,Switches.index(999))
    assert_equal(2,Switches.index('XXX'))
  end
end
