# Markup_Text_Position@}[NAbveLXg|WV
# Authors:: fukuyama
# Date:: 2012/01/11
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License
#
# \bottom
# \left[dummy]
# \right[dummy]
# \center[dummy]
# \center_left[dummy]
# \center_right[dummy]
# \current_line[s]
#
class Window_Base

  # \bottom
  add_process_character('bottom') do
    def process(w,txt,pos)
      pos[:y] = w.contents.height - w.line_height
    end
  end

  # \left[dummy]
  add_process_character('left') do
    def process(w,txt,pos)
      param = w.obtain_escape_param_string(txt)
      pos[:x] = 0
      if not param.nil?
        w.process_character(param.slice!(0, 1), param, pos) until param.empty?
      end
    end
  end

  # \right[dummy]
  add_process_character('right') do
    def process(w,txt,pos)
      param = w.obtain_escape_param_string(txt)
      if not param.nil?
        rect = w.text_size(param)
        pos[:x] = w.contents.width - rect.width
        w.process_character(param.slice!(0, 1), param, pos) until param.empty?
      end
    end
  end

  # \center[dummy]
  add_process_character('center') do
    def process(w,txt,pos)
      param = w.obtain_escape_param_string(txt)
      if not param.nil?
        rect = w.text_size(param)
        pos[:x] = w.contents.width / 2 - rect.width / 2
        w.process_character(param.slice!(0, 1), param, pos) until param.empty?
      end
    end
  end

  # \center_left[dummy]
  add_process_character('center_left') do
    def process(w,txt,pos)
      param = w.obtain_escape_param_string(txt)
      if not param.nil?
        rect = w.text_size(param)
        pos[:x] = w.contents.width / 2 - rect.width
        w.process_character(param.slice!(0, 1), param, pos) until param.empty?
      end
    end
  end

  # \center_right[dummy]
  add_process_character('center_right') do
    def process(w,txt,pos)
      param = w.obtain_escape_param_string(txt)
      if not param.nil?
        rect = w.text_size(param)
        pos[:x] = w.contents.width / 2
        w.process_character(param.slice!(0, 1), param, pos) until param.empty?
      end
    end
  end

  # \current_line[n]
  add_process_character('current_line') do
    def process(w,txt,pos)
      n = w.obtain_escape_param_string(txt)
      pos[:y] = w.line_height * n
    end
  end
end
