# DQpACeEBhEx[X
# Authors:: fukuyama
# Date:: 2011/12/19
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module DQ
  # DQpACeEBhEx[X
  class Window_Item_Base < ::DQ::Window_Command_Base
    include Window_Tree_Module
    # 
    def initialize(*args)
      super(*args)
      self.unselect
    end

    # AN^[̎擾
    def actor
      self.parent.actor
    end

    # I[i[̎擾
    def owner
      self.parent.owner
    end

    # ACe̎擾
    def item
      return current_ext
    end

    # R}hXg̍쐬
    # AN^[ACe̍XV
    def make_command_list
      if not self.actor.nil?
        equips = self.actor.equips
        items = self.actor.all_items - equips
        equips.each do |item|
          add_command('E ' + item.name, :select_item, true, item) unless item.nil?
        end
        items.each do |item|
          add_command(item.name, :select_item, true, item)
        end
      else
        # ӂ̏ꍇGame_ItemX^bN\
        $game_party.stack_items.each do |item|
          add_command(item.name, :select_item, true, item)
        end
      end
    end

    # nh[ݒ
    def set_handlers()
      # ȅꍇɁAadd_command ȂāAnh쐬Ȃꍇ̂ŁAKǉB
      set_handler(:select_item, method(:select_item))
      super
    end

    # j[̕\s
    def visible_line_number
      12
    end

    # ACȇI
    def select_item
    end

    # Sڂ̕`
    # ۂɂ͍ŏɕ\Ăy[W`悷
    def draw_all_items
      page = 0
      max = page_item_max()
      if self.index >= 0 and max > 0
        page,i = self.index.divmod(max)
      end
      for i in (page * max) ... ((page + 1) * max)
        draw_item(i) if i < item_max
      end
      @_refresh_menus = Hash.new(false)
      @_refresh_menus[page] = true
    end

    # ĕ`
    def refresh
      super
      n = item_max()
      if n == 0
        self.index = -1
        self.active_window = parent.class
      elsif n <= self.index
        self.index = n - 1
      end
    end

    # XV
    def update
      super
      # y[Wɕ`s
      max = page_item_max()
      if self.index >= 0 and max > 0
        page,i = self.index.divmod(max)
        if not @_refresh_menus.include?(page)
          # ACe̕̕`
          for i in (page * max) ... ((page + 1) * max)
            draw_item(i) if i < item_max
          end
          @_refresh_menus[page] = true
        end
      end
    end

    def draw_item(i)
      super(i)
      if self.actor.nil?
        item = @list[i][:ext]
        if $game_party.backpack.stack_item?(item)
          count = $game_party.backpack.item_number(item)
          if count > 0
            rect = item_rect_for_text(i)
            count_rect = text_size(count.to_s)
            count_rect.x = rect.x + rect.width - count_rect.width
            count_rect.y = rect.y
            self.contents.draw_text(count_rect,count.to_s,2)
          end
        end
      end
    end
  end
end
