# ёւpEBhE
# Authors:: fukuyama
# Date:: 2012/02/24
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  module Order_Control
    # o[̒ǉ
    def add_actor(actor)
      @members.push(actor)
    end

    # o[̍폜
    def remove_actor(actor=nil)
      if actor.nil?
        @members.shift
      else
        @members.delete(actor)
      end
    end

    # o[̑S폜
    def clear_actor
      @members.clear
    end

    # o[̎擾
    def members
      @members
    end
  end

  class Window_Party_Order < ::DQ::Window_Actor_Menu_Base
    include Window_Tree_Module
    include Order_Control
    # IuWFNg
    def initialize(parent)
      @members = $game_party.members.dup
      super(parent,parent.right - parent.width * 0.5,parent.top_window.top)
      @window_party_order_after = Window_Party_Order_After.new(self)
      add_child(@window_party_order_after)
    end

    # ̏
    def process_ok
      if current_data.nil?
        # f[^ꍇAŌȂ̂őύX
        Sound.play_ok
        Input.update
        deactivate
        $game_party.members.each() do |actor|
          $game_party.remove_actor(actor.id)
        end
        @window_party_order_after.members.each() do |actor|
          $game_party.add_actor(actor.id)
        end
        $game_player.refresh
        top_window.close
      else
        # f[^ꍇAʏ̏
        super
      end
    end

    # AN^[Ȉ
    def select_actor
      @window_party_order_after.add_actor(self.actor)
      @window_party_order_after.refresh
      self.remove_actor(self.actor)
      self.refresh
      if self.index >= members.size
        self.index = members.size - 1
      end
      if current_data.nil?
        self.unselect
      end
      activate
    end

    # LZ̏
    def cancel
      if @window_party_order_after.members.empty?
        close
        return
      end
      @window_party_order_after.remove_actor()
      @window_party_order_after.refresh
      self.clear_actor
      $game_party.members.each() do |actor|
        if not @window_party_order_after.members.include?(actor)
          self.add_actor(actor)
        end
      end
      self.refresh
      if self.index < 0
        self.index = 0
      end
      activate
    end

  end

  class Window_Party_Order_After < ::DQ::Window_Actor_Menu_Base
    include Window_Tree_Module
    include Order_Control
    # IuWFNg
    def initialize(parent)
      @members = []
      super(parent,parent.right,parent.top)
      unselect
    end
    
    def visible_line_number
      $game_party.members.size()
    end
  end

end
