# -*- coding: sjis -*-
# 䕶W[̃eXg
# Authors:: fukuyama
# Date:: 2011/12/15
# Copyright:: Copyright (c) 2011 rgss-lib

require 'Win32API'
require 'kconv'
require 'test/unit'
require 'debug/debug_base'
require 'debug/default_require'
require 'common/process_character_module'

# 䕶W[̃eXg
class Process_Character_Module_Test < Test::Unit::TestCase
  def setup
    Debug.create_normal_database
    DataManager.create_game_objects
  end

  def test_obtain_escape_code_01
    w = Window_Base.new(0,0,0,0)
    txt = 'C[10]'
    code = w.obtain_escape_code(txt)
    assert_equal('C',code)
    assert_equal('[10]',txt)
  end

  def test_obtain_escape_code_02
    w = Window_Base.new(0,0,0,0)
    txt = 'I[10]'
    code = w.obtain_escape_code(txt)
    assert_equal('I',code)
    assert_equal('[10]',txt)
  end

  def test_obtain_escape_code_03
    w = Window_Base.new(0,0,0,0)
    txt = '$item[10]'
    code = w.obtain_escape_code(txt)
    assert_equal('$',code)
    assert_equal('item[10]',txt)
  end

  def test_obtain_escape_code_04
    w = Window_Base.new(0,0,0,0)
    txt = '!item[10]'
    code = w.obtain_escape_code(txt)
    assert_equal('!',code)
    assert_equal('item[10]',txt)
  end

  def test_obtain_escape_code_05
    w = Window_Base.new(0,0,0,0)
    txt = '.item[10]'
    code = w.obtain_escape_code(txt)
    assert_equal('.',code)
    assert_equal('item[10]',txt)
  end

  def test_obtain_escape_code_06
    w = Window_Base.new(0,0,0,0)
    txt = 'item.name[10]'
    code = w.obtain_escape_code(txt)
    assert_equal('item.name',code)
    assert_equal('[10]',txt)
  end

  def test_obtain_escape_param_01
    w = Window_Base.new(0,0,0,0)
    txt = '[10]\eC[10]'
    param = w.obtain_escape_param(txt)
    assert_equal(10,param)
    assert_equal('\eC[10]',txt)
  end

  def test_obtain_escape_param_02
    w = Window_Base.new(0,0,0,0)
    txt = '[ABC][ABCAAA]'
    param = w.obtain_escape_param(txt)
    assert_equal('ABC',param)
    assert_equal('[ABCAAA]',txt)
  end

  def test_obtain_escape_param_03
    w = Window_Base.new(0,0,0,0)
    txt = '[ABC,10,20,30X]'
    param = w.obtain_escape_param(txt)
    assert_equal(['ABC',10,20,'30X'],param)
    assert_equal('',txt)
  end

  def test_process_escape_character_01
    w = Window_Base.new(0,0,0,0)
    pos = {}
    txt = 'C[10]'
    code = w.obtain_escape_code(txt)
    w.process_escape_character(code,txt,pos)
    assert_equal('',txt)
  end

  def test_process_escape_character_02
    w = Window_Base.new(0,0,0,0)
    pos = {}
    txt = '{ABC}AAA'
    code = w.obtain_escape_code(txt)
    w.process_escape_character(code,txt,pos)
    assert_equal('ABC}AAA',txt)
  end

  def test_process_escape_character_03
    w = Window_Base.new(0,0,0,0)
    pos = {}
    txt = '}AAA'
    code = w.obtain_escape_code(txt)
    w.process_escape_character(code,txt,pos)
    assert_equal('AAA',txt)
  end
end
