# -*- coding: sjis -*-
# ϐW[̃eXg
# Authors:: fukuyama
# Date:: 2011/12/21
# Copyright:: Copyright (c) 2011 rgss-lib

require 'Win32API'
require 'kconv'
require 'test/unit'
require 'debug/debug_base'
require 'debug/default_require'
require 'common/Variables'

class Variables_Test < Test::Unit::TestCase
  def setup
    Debug.create_normal_database
    DataManager.create_game_objects
    $data_system.variables[1] = 'DEF'
    $data_system.variables[2] = 'XXX'
    Variables.init
    Variables[1] = 2
  end

  def test_variable_01
    assert_equal(2,Variables[1])
    assert_equal(0,Variables[2])
    assert_equal(2,Variables['DEF'])
    assert_equal(0,Variables['ABC'])
    assert_equal(0,Variables[999])
    assert_equal(0,Variables['XXX'])
  end

  def test_variable_02
    assert_equal(2,Variables[1,1])
    assert_equal(0,Variables[2,1])
    assert_equal(1,Variables[3,1])
    assert_equal(2,Variables['DEF',1])
    assert_equal(2,Variables['DEF',2])
    assert_equal(1,Variables['ABC',1])
    assert_equal(0,Variables['ABC',0])
    assert_equal(0,Variables['XXX',1])
  end

  def test_variable_03
    assert_equal(2,Variables[1])
    assert_equal(3,Variables[1] = 3)
    assert_equal(3,Variables[1])
    Variables[1] = 2
    assert_equal(2,Variables[1])
    assert_equal(0,Variables['XXX'])
    assert_equal(3,Variables['XXX'] = 3)
    assert_equal(3,Variables['XXX'])
    Variables['XXX'] = 0
    assert_equal(0,Variables['XXX'])

    Variables[999] = 10
    assert_equal(0,Variables[999])
    Variables['ABC'] = 10
    assert_equal(0,Variables['ABC'])
  end

  def test_include?
    assert_equal(false,Variables.include?('ABC'))
    assert_equal(true,Variables.include?('DEF'))
    assert_equal(false,Variables.include?(0))
    assert_equal(true,Variables.include?(1))
    assert_equal(true,Variables.include?(2))
    assert_equal(false,Variables.include?(3))
  end

  def test_index
    assert_equal(-1,Variables.index('ABC'))
    assert_equal(1,Variables.index('DEF'))
    assert_equal(-1,Variables.index(0))
    assert_equal(1,Variables.index(1))
    assert_equal(2,Variables.index(2))
    assert_equal(-1,Variables.index(3))
    assert_equal(-1,Variables.index(999))
    assert_equal(2,Variables.index('XXX'))
  end
end
