#==============================================================================
#  Window_Menu_Module
#------------------------------------------------------------------------------
# EBhEj[W[
# Copyright (C) 2005 fukuyama
#==============================================================================

module Window_Menu_Module
  # JCX^Xϐ
  attr_reader   :index                    # J[\ʒu
  # j[
  class Menu
    attr_accessor :name   # j[
    attr_accessor :handler # j[nh
    def initialize(name, handler)
      @name = name
      @handler = handler
    end
  end

  # 
  def initialize(*arg)
    @index = -1 if @index.nil?
    @menus = [] if @menus.nil?
    super(*arg)
  end

  # j[mF
  def exist_menu?(name)
    menu = @menus.find() {|m| m.name == name}
    return (not menu.nil?)
  end

  # j[̒ǉ
  def add_menu(name, handler)
    @menus = [] if @menus.nil?
    case handler
    when Symbol
      handler = method handler
    when String
      handler = method handler
    end
    @menus.push Menu.new(name, handler)
    @item_max = @menus.size
  end

  # j[̑}
  def insert_menu(index, name, handler)
    @menus = [] if @menus.nil?
    case handler
    when Symbol
      handler = method handler
    when String
      handler = method handler
    end
    @menus.insert(index, Menu.new(name, handler))
    @item_max = @menus.size
  end

  # j[f[^I
  def select_menu(name)
    menu = @menus.find() {|m| m.name == name}
    return if menu.nil?
    @index = @menus.index(menu)
  end

  # j[f[^擾
  def get_menu
    return nil if @index < 0
    return nil if @menus[@index].nil?
    return @menus[@index].name
  end

  # j[f[^擾
  def get_last_menu
    return nil if @menus.empty?
    return @menus[@menus.size - 1].name
  end

  # j[̃TCY
  def menu_size
    return @menus.size
  end

  # j[̍폜
  def remove_menu(index = nil)
    return if @menus.empty?
    if index.nil?
      index = @menus.size - 1
    end
    @menus.delete_at @index
    @item_max = @menus.size
  end

  # j[NA
  def clear
    @menus = [] if @menus.nil?
    @menus.clear
    @item_max = @menus.size
  end

  # j[s
  def menu_call(index)
    return if @menus[index].nil?
    @menus[index].handler.call
  end
end
