# }bv[v
# Author:: fukuyama
# Date:: 2009/02/11
# Copyright:: Copyright (c) 2009 rgss-lib

module Map_Loop
  # }bv[vftHgݒ
  DEFAULT_LOOP_HORIZONTAL = false
  DEFAULT_LOOP_VERTICAL = false
  @@_loop_horizontal_list = Hash.new(DEFAULT_LOOP_HORIZONTAL.freeze)
  @@_loop_vertical_list = Hash.new(DEFAULT_LOOP_VERTICAL.freeze)

  module_function

  # [v\
  def loop_horizontal?
    return @@_loop_horizontal_list[$game_map.map_id]
  end
  def loop_vertical?
    return @@_loop_vertical_list[$game_map.map_id]
  end

  # }bv[v`A}bvhcƐ^Ul̃nbV
  def loop_horizontal_list
    @@_loop_horizontal_list
  end
  def loop_vertical_list
    @@_loop_vertical_list
  end
end

class Game_Map

  # Ƀ[v邩H
  def loop_horizontal?
    return Map_Loop.loop_horizontal?
  end

  # cɃ[v邩H
  def loop_vertical?
    return Map_Loop.loop_vertical?
  end

end

# optimize spriteset-map Kv
class Spriteset_Map

  # tHÕZbg
  def reset_fog
    # tHÔ݂̂ƈقȂꍇ
    if @fog_name != $game_map.fog_name or @fog_hue != $game_map.fog_hue
      @fog_name = $game_map.fog_name
      @fog_hue = $game_map.fog_hue
      if @fog.bitmap != nil
        @fog.bitmap.dispose
        @fog.bitmap = nil
      end
      if @fog_name != ""
        @fog.bitmap = RPG::Cache.fog(@fog_name, @fog_hue)
      end
      Graphics.frame_reset
    end
  end

  # tHOv[XV
  def update_fog
    @fog.zoom_x = $game_map.fog_zoom / 100.0
    @fog.zoom_y = $game_map.fog_zoom / 100.0
    @fog.opacity = $game_map.fog_opacity
    @fog.blend_type = $game_map.fog_blend_type
    @fog.ox = $game_map.fog_x / 4 + $game_map.fog_ox
    @fog.oy = $game_map.fog_y / 4 + $game_map.fog_oy
    @fog.tone = $game_map.fog_tone
  end

end
