# Markup_Font_Color
#
# \C[0`7]     w肳ꂽԍ̃J[ɕύXiWindow_BaseQƁj
# \C[s]        VXeJ[ɕύXiWindow_BaseQƁj
# \C[n]        m[}J[ɕύXiWindow_BaseQƁj
# \C[cs]       NCVXJ[ɕύXiWindow_BaseQƁj
# \C[ko]       mbNAEgJ[ɕύXiWindow_BaseQƁj
# \C[r,g,b,o]  RGBJ[Ɠxw肵ătHgJ[ύX
#
# Author:: fukuyama
# Date:: 2007/07/07
# Copyright:: Copyright (c) 2005-2007 rgss-lib

# io[J[
module Markup_Font_Color
  @@text_color = nil
  module_function
  def setup_text_color(window)
    if @@text_color.nil?
      @@text_color = []
      for i in 0..7
        @@text_color[i] = window.text_color(i)
      end
    end
  end
  def query
    return /^\\C\[([0-7])\]/
  end
  def transfer(bmp, x, y, text, match)
    bmp.font.color = @@text_color[match[1].to_i]
    text[query] = ''
    return x,y,text
  end
end

# VXeJ[
module Markup_Font_Color_System
  @@system_color = nil
  module_function
  def setup_text_color(window)
    if @@system_color.nil?
      @@system_color = window.system_color
    end
  end
  def query
    return /^\\C\[s\]/
  end
  def transfer(bmp, x, y, text, match)
    bmp.font.color = @@system_color
    text[query] = ''
    return x,y,text
  end
end

# m[}J[
module Markup_Font_Color_Normal
  @@normal_color = nil
  module_function
  def setup_text_color(window)
    if @@normal_color.nil?
      @@normal_color = window.normal_color
    end
  end
  def query
    return /^\\C\[n\]/
  end
  def transfer(bmp, x, y, text, match)
    bmp.font.color = @@normal_color
    text[query] = ''
    return x,y,text
  end
end

# NCVXJ[
module Markup_Font_Color_Crisis
  @@crisis_color = nil
  module_function
  def setup_text_color(window)
    if @@crisis_color.nil?
      @@crisis_color = window.crisis_color
    end
  end
  def query
    return /^\\C\[cs\]/
  end
  def transfer(bmp, x, y, text, match)
    bmp.font.color = @@crisis_color
    text[query] = ''
    return x,y,text
  end
end

# mbNAEgJ[
module Markup_Font_Color_Knockout
  @@knockout_color = nil
  module_function
  def setup_text_color(window)
    if @@knockout_color.nil?
      @@knockout_color = window.knockout_color
    end
  end
  def query
    return /^\\C\[ko\]/
  end
  def transfer(bmp, x, y, text, match)
    bmp.font.color = @@knockout_color
    text[query] = ''
    return x,y,text
  end
end

# ڍ׎wJ[
module Markup_Font_Color_Detail
  module_function
  def query
    return /^\\C\[([0-9]+),([0-9]+),([0-9]+),([0-9]+)\]/
  end
  def transfer(bmp, x, y, text, match)
    r = match[1].to_i
    g = match[2].to_i
    b = match[3].to_i
    o = match[4].to_i
    bmp.font.color = Color.new(r,g,b,o)
    text[query] = ''
    return x,y,text
  end
end

String_Operation_Module.add_markup(Markup_Font_Color)
String_Operation_Module.add_markup(Markup_Font_Color_System)
String_Operation_Module.add_markup(Markup_Font_Color_Normal)
String_Operation_Module.add_markup(Markup_Font_Color_Crisis)
String_Operation_Module.add_markup(Markup_Font_Color_Knockout)
String_Operation_Module.add_markup(Markup_Font_Color_Detail)

# iƂ肠j
# ʊ֐W[ĂȂ̂ł̕@vȂc
class Window_Base
  @@markup_initialize = false
  alias initialize_Markup_Font_Color initialize
  def initialize(*arg)
    initialize_Markup_Font_Color(*arg)
    unless @@markup_initialize
      Markup_Font_Color.setup_text_color(self)
      Markup_Font_Color_System.setup_text_color(self)
      Markup_Font_Color_Normal.setup_text_color(self)
      Markup_Font_Color_Crisis.setup_text_color(self)
      Markup_Font_Color_Knockout.setup_text_color(self)
      @@markup_initialize = true
    end
  end
end
