# Markup_Map_Name
#
# \map.name[c] ݒn}bv
# \map.name[t] gbv}bv
# \map.name[ID]  ID=l IDŎw肵}bvID̃}bv
# \map.name[KEY] KEY= KEYtĂ}bv(KEY͕\Ȃ)
#

module Markup_Map_Name
  module_function
  def query
    return /\\map[\._]na?me?\[(.+?)\]/
  end
  def transfer(obj, text, match)
    key = match[1].to_s
    text[query] = get_map_name(key)
  end
  def get_map_name(key)
    map_infos = Data_Loader.data_map_infos
    map_info = map_infos[$game_map.map_id]
    case key
    when "c" # ݒn
      return map_info.name
    when "t" # gbv
      while map_info.parent_id != 0
        map_info = map_infos[map_info.parent_id]
      end
      return map_info.name
    end
    
    # }bvhcw
    if key =~ /^[0-9]+$/
      return map_infos[key.to_i].name
    end
    
    # KEY w
    exp = Regexp.escape(key)
    while map_info.parent_id != 0
      if map_info.name[/(.*)#{exp}$/]
        return $1
      end
      map_info = map_infos[map_info.parent_id]
    end
    return map_info.name
  end
end

String_Replace_Module.add_markup(Markup_Map_Name)
