# zC[XN[擾 Ver.1.0.0
# Author:: a
# Date:: 2006/01/30
# Copyright:: Copyright (c) 2006 a(rgss-lib)
#-----------------------------------------------------------
# Cxg擾ɂ MouseWheel.new ĂB
# V[main̍ŏȂǂŃO[o̓NXϐȂǂ
# A΂Ǝv܂B
# 
# )
#   $mouse_wheel = MouseWheel.new
# 
# ܂AMouseWheel̃CX^X͕svɂȂ
# KdisposeĂB
# 
# )
#   $mouse_wheel.dispose
#   $mouse_wheel = nil
# 
# zC[Cxg擾ɂ get_event \bh܂
# read_event \bhgp܂B
# ҂̈Ⴂ͓ǂݎɃL[菜A菜
# Ƃ_łB
# ܂Ã\bh̓zC[CxgĂȂ
# ꍇAnilԂ܂B
# ǂݎľ`͗QlɂĂ
# 
# )
#   ret = $mouse_wheel.get_event
#   if ret.nil?
#     p "zC[Cxg͔Ă܂"
#   else
#     x = ret.x # zC[𓮂Ƃ̃}EXW(X)
#     y = ret.y # zC[𓮂Ƃ̃}EXW(Y)
#     v = ret.scroll # zC[̃XN[
#     p "W(#{x},#{y})ŃzC[#{v}񂳂܂"
#   end
# 
# Ӂcx,y͉ʑŜ̍WłB
# @@@@(cN[̍Wł͂܂)
# 
# XN[Cxgʂɒ܂ďȂȂǂ
# flash \bhނƂ܂B
# ܂Cxg܂B
# 
# )
#   $mouse_wheel.flash
#
# ܂肱Ƃł
# $mouse_wheel.get_event  Input.trigger?
# $mouse_wheel.read_event  Input.repeat?
# $mouse_wheel.flash  Input.update
# 

# WindowMessageIuU[o
module WMObserver
  # WindowMessageMƂ̃\bhĂ΂܂
  # ̃W[includeăI[o[Ch邩
  # Ã\bh쐬Ă
  def wmcallback(msg)
    str = "hWnd = #{msg.hwnd}, msgId = #{msg.message}"
    p str
  end
end

# WindowMessage̔zMsNX
class WMServer
  # POINT\
  POINT = Struct.new(:x, :y)
  # MSG\
  MSG = Struct.new(:hwnd, :message, :wparam, :lparam, :time, :pt)

  # g̃CX^X
  @@self = nil
  # IuU[o̔z
  attr_accessor :observers

  # Stringobt@offseẗʒuɂ4oCgǂݎ܂
  def self.unpack_dword(buffer, offset = 0)
    ret  =  buffer[offset + 0]           & 0x000000ff
    ret |= (buffer[offset + 1] << (8*1)) & 0x0000ff00
    ret |= (buffer[offset + 2] << (8*2)) & 0x00ff0000
    ret |= (buffer[offset + 3] << (8*3)) & 0xff000000
    return ret
  end

  # Stringobt@MSG\̂ɕϊ܂
  def self.unpack_msg(buffer)
    msg = MSG.new
    msg.pt = POINT.new
    msg.hwnd    = WMServer.unpack_dword(buffer, 4*0)
    msg.message = WMServer.unpack_dword(buffer, 4*1)
    msg.wparam  = WMServer.unpack_dword(buffer, 4*2)
    msg.lparam  = WMServer.unpack_dword(buffer, 4*3)
    msg.time    = WMServer.unpack_dword(buffer, 4*4)
    msg.pt.x    = WMServer.unpack_dword(buffer, 4*5)
    msg.pt.y    = WMServer.unpack_dword(buffer, 4*6)
    return msg
  end

  # g̃CX^XԂ܂
  def self.static
    if @@self.nil?
      @@self = self.new
    end
    return @@self
  end

  # IuU[oo^܂
  def add_observer(observer)
    @observers.push(observer)
    start
  end

  # IuU[o̓o^܂
  def delete_observer(observer)
    @observers.delete(observer)
  end

  # WindowMessage̔zMJn܂
  def start
    return unless @thread.nil?
    @thread = Thread.new {
      get_message = Win32API.new('User32', 'GetMessage', 'plll', 'l')
      translate_message = Win32API.new('User32', 'TranslateMessage', 'p', 'l')
      dispatch_message = Win32API.new('User32', 'DispatchMessage', 'p', 'l')
      while @observers.size > 0
        msg = "\0" * 32
        ret = get_message.call(msg, 0, 0, 0)
        case ret
        when 0xFFFFFFFF
          p "WMServerG[:GetMessageɎs܂"
        when 0
          exit
        else
          translate_message.call(msg)
          dispatch_message.call(msg)
          struct_msg = WMServer.unpack_msg(msg)
          @observers.each { |observer|
            observer.wmcallback(struct_msg)
          }
        end
      end
      @thread = nil
    }
  end

  # 
  def initialize
    @observers = []
  end
end


# }EXzC[NX
class MouseWheel
  include WMObserver # WMT[õIuU[oƎ咣Ă݂(Ӗ)

  WM_MOUSEWHEEL = 0x0000020A # zC[bZ[WID

  # zC[Cxg̃p[^
  # x:: }EXW(X)
  # y:: }EXW(Y)
  # scroll:: zC[̃XN[
  PARAM = Struct.new(:x, :y, :scroll)

  attr_accessor :queue # bZ[WL[

  # BWMT[o֓o^
  def initialize
    @queue = []
    WMServer.static.add_observer(self)
  end

  # JB
  # WMT[o邽߂ɕKĂԂ
  def dispose
    WMServer.static.delete_observer(self)
  end

  # zC[Cxgo܂
  def get_event
    return @queue.shift
  end

  # zC[CxgoɎQƂ܂
  def read_event
    return @queue.first
  end

  # zC[CxgtbV܂
  def flash
    @queue = []
  end

  # WORD𕄍萮ɕύX܂
  def word2signed_short(value)
    if (value & 0x8000) == 0
      return value
    end
    return -1 * ((~value & 0x7fff) + 1)
  end

  # DWORD̏WORD𒊏o܂
  def hiword(dword)
    ret = ((dword & 0xffff0000) >> 16) & 0x0000ffff
  end

  # DWORD̉WORD𒊏o܂
  def loword(dword)
    ret = dword & 0x0000ffff
  end

  # WindowMessageR[obN\bh
  def wmcallback(msg)
    return unless msg.message == WM_MOUSEWHEEL

    param = PARAM.new
    param.x =      word2signed_short(loword(msg.lparam))
    param.y =      word2signed_short(hiword(msg.lparam))
    param.scroll = word2signed_short(hiword(msg.wparam))

    @queue.push(param)
  end
end

