#==============================================================================
#  Window_Actor_Command
#------------------------------------------------------------------------------
# AN^[R}hEBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
module Battle

class Window_Actor_Command < ::DQ::Battle::Window_Page_Menu
  include Window_Tree_Module
  include Window_Target_Module

  attr_accessor :targets
  attr_accessor :skill
  attr_accessor :item

  attr_reader   :actor

  def initialize(actor)
    @actor = actor
    @target_enemies = []

    @title = @actor.name

    add_menu('', :command_attack)
    add_menu('', :command_skill)
    add_menu('ǂ',   :command_item)
    add_menu('ڂ', :command_guard)
#    add_menu('ɂ',   :unsupport)
#    add_menu('Ƃ',   :unsupport)
#    add_menu('',   :unsupport)
    @index = 0
    @column_max = 1
    @item_use = false
    @item_equip = false

    super(nil)

    self.screen_bottom(16)
    self.left = $scene.message_window.x
  end

  def attack?
    return @index == 0
  end
  def skill?
    return @index == 1
  end
  def item?
    return @index == 2
  end
  def guard?
    return @index == 3
  end
  def cancel?
    return @index == -1
  end
  def item_use?
    return @item_use
  end
  def item_equip?
    return @item_equip
  end
  def item_use=(b)
    @item_use = b
    @item_equip = (not b)
  end
  def item_equip=(b)
    @item_equip = b
    @item_use = (not b)
  end

  def command_attack
    target_enemy
  end
  def command_skill
    window = Window_Skill.new(self,@actor)
    set_active_window(window.class)
  end
  def command_item
    window = Window_Item.new(self,@actor)
    set_active_window(window.class)
  end
  def command_guard
    dispose
  end

  #---------------------------------------------------------------------------
  # LZ
  #---------------------------------------------------------------------------
  def input_b
    if event_handling_trigger?
      @index = -1
      cancel_se
      dispose
    end
  end

  #---------------------------------------------------------------------------
  # Rec̍쐬
  def _contents_width
    return _menu_width
  end
  #---------------------------------------------------------------------------
  # j[̍쐬
  def _menu_width
    return BATTLE_WINDOW_ACTOR_COMMAND_WIDTH
  end
end

end
end
