#==============================================================================
#  Event_Script
#------------------------------------------------------------------------------
# cppHCxgXNvg
# Copyright (C) 2005,2007 fukuyama
#==============================================================================

module Event_Script
  @@window_savedata_select = nil
  @@window_savedata_select_index = -1

  module_function
  #--------------------------------------------------------------------------
  # Z[uӏ̑I
  #--------------------------------------------------------------------------
  def savedata_select(variable_id=nil)
    if @@window_savedata_select.nil?
      @@window_savedata_select = DQ::Window_SaveData_Select.new
      @@window_savedata_select.index = $game_temp.last_file_index
    end
    if @@window_savedata_select.disposed?
      if not variable_id.nil?
        Variables[variable_id] = @@window_savedata_select.index
      else
        @@window_savedata_select_index = @@window_savedata_select.index
      end
      @@window_savedata_select = nil
      return true
    end
    @@window_savedata_select.update
    return false
  end

  #--------------------------------------------------------------------------
  # ㏑
  #--------------------------------------------------------------------------
  def savedata_overwrite?(variable_id=nil)
    index = @@window_savedata_select_index
    if not variable_id.nil?
      index = Variables[variable_id]
    end
    savedatas = DQ::SaveData_Facade.load_index
    return (not savedatas[index].nil?)
  end

  #--------------------------------------------------------------------------
  # Z[u
  #--------------------------------------------------------------------------
  def save(*args)
    index,name,lv,comment = *args
    if index.nil?
      index = @@window_savedata_select_index
    elsif index.is_a?(String)
      index = Variables[index]
    end
    if index < 0
      return true
    end
    # vC[AN^[ID̎擾
    player_actor_id = $game_player.actor_id
    if name.nil?
      name = $game_actors[player_actor_id].name
    end
    if not lv.is_a?(Numeric)
      lv = $game_actors[player_actor_id].level
    end
    if comment.nil?
      data_map_infos = Data_Loader.data_map_infos
      comment = data_map_infos[$game_map.map_id].name
    end
    $game_system.map_interpreter.increment_index
    DQ::SaveData_Facade.save(index,name,lv,comment)
    $game_system.map_interpreter.decrement_index
    return true
  end
end

class Interpreter
  def increment_index
    if @child_interpreter.nil?
      @index += 1
    else
      @child_interpreter.increment_index
    end
  end
  def decrement_index
    if @child_interpreter.nil?
      @index -= 1
    else
      @child_interpreter.decrement_index
    end
  end
end
