#==============================================================================
#  Window_Actor_Menu_Status
#------------------------------------------------------------------------------
# 悳AN^[j[
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  class Window_Actor_Menu_Status < Window_Actor_Menu_Base
    #----------------------------------------------------------------------------
    # 
    #----------------------------------------------------------------------------
    def initialize(parent,title)
      super(parent,title)

      # j[ǉ
      add_menu('񂢂', :all_status)
      pack

      # ʒu̐ݒ
      rect = parent.menu_rect(parent.index)
      self.top = parent.top + rect.y
      self.left = parent.left

      @actor_status_windows = []
      @all_status_windows = []

      # AN^[ȈՃXe[^X
      @window_actor_summary = Window_Status_Summary.new(self.actor)
      @window_actor_summary.left = self.right
      @window_actor_summary.top  = get_window(Window_Main_Menu).top
      @window_actor_summary.back_opacity = self.back_opacity
      @actor_status_windows.push @window_actor_summary

      # AN^[ڍ׃Xe[^X
      @window_actor_status_detail = Window_Status_Detail.new(self.actor)
      @window_actor_status_detail.left = @window_actor_summary.right
      @window_actor_status_detail.top  = @window_actor_summary.top
      @window_actor_status_detail.back_opacity = self.back_opacity
      @actor_status_windows.push @window_actor_status_detail

      # AN^[
      @window_actor_equip_item = Window_Status_Equip.new(self.actor)
      @window_actor_equip_item.left = @window_actor_summary.left
      @window_actor_equip_item.top  = @window_actor_summary.bottom
      @window_actor_equip_item.back_opacity = self.back_opacity
      @actor_status_windows.push @window_actor_equip_item

      # vCԃEBhE
      add_all_status_windows Window_Status_PlayTime.new

      # S[hEBhE
      add_all_status_windows Window_Status_Gold.new

      if Module.constants.include?('WINDOW_STATUS_VARIABLES')
        for v in WINDOW_STATUS_VARIABLES
          window = add_all_status_windows Window_Markup_Text.new(0,0,ALL_STATUS_WIDTH + 32,Markup_New_Line.line_height + 32)
          window.set_text(v)
        end
      end

      self.actor_status_visible = true
    end

    def add_all_status_windows(window)
      window.left = self.right
      if @all_status_windows.empty?
        window.top = top_window.top
      else
        window.top = @all_status_windows.last.bottom
      end
      window.back_opacity = self.back_opacity
      @all_status_windows.push window
      return window
    end

    def dispose
      @actor_status_windows.each do |window|
        window.dispose
      end
      @all_status_windows.each do |window|
        window.dispose
      end
      super
    end

    def all_status
      window = Window_Status_All.new(self)
      set_active_window(window.class)
    end

    def select_actor
      if not Skill_Facade.actor_class_skills(actor).empty?
        window = Window_Status_Skill.new(self)
        set_active_window(window.class)
      end
    end

    def change_actor
      if self.actor.nil?
        self.all_status_visible = true
      else
        self.actor_status_visible = true
        @actor_status_windows.each do |window|
          window.actor = self.actor
        end
      end
    end

    def actor_status_visible=(visible)
      @actor_status_windows.each do |window|
        window.visible = visible
        window.z = self.z
      end
      @all_status_windows.each do |window|
        window.visible = (not visible)
        window.z = self.z
      end
    end

    def all_status_visible=(visible)
      self.actor_status_visible = (not visible)
    end
  end

end
