#==============================================================================
#  Window_Item_Menu
#------------------------------------------------------------------------------
# ACej[EBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  class Window_Item_Menu < ::DQ::Window_Page_Menu
    include Window_Tree_Module
    include Menu_Log_Item_Module
    #--------------------------------------------------------------------------
    # 
    #--------------------------------------------------------------------------
    def initialize(parent)
      @title = 'ǂH'
      actor = parent.get_window(Window_Actor_Menu_Item).actor
      item = parent.get_window(Window_Item).item
      add_menu('',:use_item)
      add_menu('킽',:trade_item)
      if actor.is_a? Game_Actor
        if Item_Facade.actor_equip?(item,actor)
          add_menu('͂',:remove_equip_item)
        else
          add_menu('',:equip_item)
        end
      end
      add_menu('Ă',:throw_item)
      add_menu('߂',:exit_window)
      @index = 0
      super(parent)

      # ʒu̐ݒ
      self.screen_bottom(16 + 32)
      self.right = parent.left
    end

    #--------------------------------------------------------------------------
    # XV
    #--------------------------------------------------------------------------
    def update
      if @message_end
        dispose
        get_window(Window_Item).refresh
        return
      end
      super
    end

    #--------------------------------------------------------------------------
    # 
    #--------------------------------------------------------------------------
    def use_item
      owner_actor = get_window(Window_Actor_Menu_Item).actor
      owner_actor = get_window(Window_Actor_Menu_Item).backpack if owner_actor.nil?
      item = get_window(Window_Item).item
      use_item = Item_Facade.get_use_item(item)
      # ȂACeꍇ
      if use_item.nil?
        menu_log_use_item_miss(item,owner_actor)
        @message_end = true
        return
      end
      if (use_item.scope_all? and use_item.scope_friend?) or # ΏۂŜ̏ꍇ
      (use_item.scope_nil? and use_item.common_event_id != 0) # ́AΏۂȂŁARCxghcꍇ
        if not Item_Facade.item_can_use?(item,owner_actor)
          menu_log_use_item_miss(use_item,owner_actor)
          @message_end = true
          return
        end
        used = Item_Facade.use_item(item,owner_actor,$game_party.actors)
        # ACegꍇ
        if used
          menu_log_use_item(use_item,owner_actor,$game_party.actors)
          @message_end = true
          return
        end
      elsif use_item.scope_single? and use_item.scope_friend? # ΏۂP̂̏ꍇ
        window = Window_Actor_Menu_Item_Use.new(self)
        add_child window
        set_active_window(window.class)
        return
      else
        menu_log_use_item_miss(use_item,owner_actor)
        @message_end = true
        return
      end
    end

    #--------------------------------------------------------------------------
    # 킽
    #--------------------------------------------------------------------------
    def trade_item
      actor = get_window(Window_Actor_Menu_Item).actor
      item = parent.get_window(Window_Item).item
      # Œ肳Ăꍇ
      if Item_Facade.actor_equip?(item,actor)
        if Item_Facade.equip_fix?(item,actor)
          menu_log_trade_item_fix(item,actor)
          @message_end = true
          return
        end
      end
      window = Window_Actor_Menu_Item_Trade.new(self,'ɁH')
      add_child window
      set_active_window(window.class)
    end

    #--------------------------------------------------------------------------
    # 
    #--------------------------------------------------------------------------
    def equip_item
      actor = get_window(Window_Actor_Menu_Item).actor
      item = get_window(Window_Item).item
      # Œ肳Ăꍇ
      if Item_Facade.equip_fix?(item,actor)
        menu_log_equip_item_fix(item,actor)
        @message_end = true
        return
      end
      if item.is_a?(Game_Item)
        # O
        menu_log_equip_item_error(item)
      elsif not Item_Facade.equippable?(item,actor)
        # O
        menu_log_equip_item_actor_error(item,actor)
      elsif (not actor.nil?) and (not item.nil?)
        actor.equip_item(item)
        # SE
        equip_se
        # O
        menu_log_equip_item(item,actor)
      end
      @message_end = true
    end

    #--------------------------------------------------------------------------
    # ͂
    #--------------------------------------------------------------------------
    def remove_equip_item
      actor = get_window(Window_Actor_Menu_Item).actor
      item = get_window(Window_Item).item
      if (not actor.nil?) and (not item.nil?)
        # Œ肳Ăꍇ
        if Item_Facade.equip_fix?(item,actor)
          menu_log_remove_equip_item_fix(item,actor)
          @message_end = true
          return
        end
        actor.remove_equip_item(item)
        # SE
        equip_se
        # O
        menu_log_remove_equip_item(item,actor)
        @message_end = true
      end
    end

    #--------------------------------------------------------------------------
    # Ă
    #--------------------------------------------------------------------------
    def throw_item
      actor = get_window(Window_Actor_Menu_Item).actor
      if actor.nil?
        actor = get_window(Window_Actor_Menu_Item).backpack
      end
      item = get_window(Window_Item).item
      if Item_Facade.item_can_throw?(item,actor)
        case actor
        when Game_Actor
          # Œ肳Ăꍇ
          if Item_Facade.actor_equip?(item,actor)
            if Item_Facade.equip_fix?(item,actor)
              menu_log_throw_item_fix(item,actor)
              @message_end = true
              return
            end
          end
          menu_log_throw_item_actor(item,actor)
        when Game_Party
          menu_log_throw_item_party(item,actor)
        end
      else
        menu_log_throw_item_error(item,actor)
      end
      @message_end = true
    end

    #--------------------------------------------------------------------------
    # ߂
    #--------------------------------------------------------------------------
    def exit_window
      cancel_se
      if not top_window.disposed?
        top_window.dispose
      end
    end

    #---------------------------------------------------------------------------
    # Rec̍쐬
    def _contents_width
      return ACTOR_MENU_WIDTH
    end
  end

end
