#==============================================================================
#  Markup_Shake
#------------------------------------------------------------------------------
# \SH[,,]  bZ[WVFCNB
# \SV[,,]  bZ[WVFCNB
# ӁFSprite_Message + Shake_Modulê
#==============================================================================

module Markup_Shake_Horizontal
  module_function
  def query
    return /^\\SH\[([0-9]+),([0-9]+),([0-9]+)\]/
  end
  def transfer(bmp, x, y, text, match)
    if $scene.is_a?(Scene_Map) or $scene.is_a?(Scene_Battle)
      power    = match[1].to_i
      speed    = match[2].to_i
      duration = match[3].to_i
      $scene.message_window.sprite_message.start_shake(power, speed, duration, 1)
    end
    text[query] = ''
    return x,y,text
  end
end

module Markup_Shake_Vertical
  module_function
  def query
    return /^\\SV\[([0-9]+),([0-9]+),([0-9]+)\]/
  end
  def transfer(bmp, x, y, text, match)
    if $scene.is_a?(Scene_Map) or $scene.is_a?(Scene_Battle)
      power    = match[1].to_i
      speed    = match[2].to_i
      duration = match[3].to_i
      $scene.message_window.sprite_message.start_shake(power, speed, duration, 2)
    end
    text[query] = ''
    return x,y,text
  end
end

String_Operation_Module.add_markup(Markup_Shake_Vertical)
String_Operation_Module.add_markup(Markup_Shake_Horizontal)
