module Data_Export
  module_function

  @@data_dir = './'
  def data_dir=(dir)
    @@data_dir = dir
  end

  @@output_dir = './output/'

  def output_dir=(dir)
    @@output_dir = dir
  end

  def output(f,a)
    f.puts a.join(',')
  end

  def headers(obj)
    return obj.instance_variables().compact().collect(){|o|o[1,o.size]}.sort()
  end

  def output_headers(file,obj)
    keys = headers(obj)
    a = keys.collect() do |ret|
      case obj.send(ret)
      when TrueClass
        ret += ':b'
      when FalseClass
        ret += ':b'
      when Numeric
        ret += ':n'
      when ::RPG::AudioFile
        ret += ':se'
      when String
      else
        ret += ':*'
      end
      ret
    end
    output(file,a)
    return keys
  end

  def output_values(file,obj,keys)
    a = keys.collect() do |key|
      ret = obj.send(key)
      case ret
      when Array
        if key == "actions"
          ret = ret.collect(){|o|"#{o.kind}:#{o.basic}:#{o.skill_id}"}.join(' ')
        elsif key == "learnings"
          ret = ret.collect(){|o|"#{o.level}:#{o.skill_id}"}.join(' ')
        elsif key == "members"
          ret = ret.collect(){|o|"#{o.enemy_id}:#{o.x}:#{o.y}:#{o.hidden}:#{o.immortal}"}.join(' ')
        elsif key == "pages"
          ret = ""
        else
          ret = ret.join(' ')
        end
      when ::RPG::AudioFile
        unless ret.name.empty?
          ret = "#{ret.name} #{ret.volume} #{ret.pitch}"
        else
          ret = ""
        end
      when Table
        if ret.ysize == 1 and ret.zsize == 1
          tbl = ret
          l = []
          for x in 0 ... tbl.xsize
            l.push("#{x}:#{tbl[x]}")
          end
          ret = l.join(' ')
        else
          ret = key + '_' + obj.id.to_s
        end
      end
      ret.to_s
    end
    output(file,a)
  end

  def output_table_yx(file,table)
    ret = ['#']
    for x in 0 ... table.xsize
      ret.push(x)
    end
    output(file,ret)
    for y in 0 ... table.ysize
      ret = [y]
      for x in 0 ... table.xsize
        ret.push(table[x,y].to_s)
      end
      output(file,ret)
    end
  end

  def rxdata_to_csv(rxdata_name,csv_name)
    data = load_data(@@data_dir + rxdata_name).compact
    file = nil
    begin
      file = File.open(@@output_dir + csv_name,'w+')
      keys = output_headers(file,data[0])
      data.each() do |obj|
        output_values(file,obj,keys)
      end
    ensure
      file.close() unless file.nil?
    end
    return data
  end

  def actors()
    actors = rxdata_to_csv('Actors.rxdata','Actors.csv')
    actors.each() do |obj|
      file = nil
      begin
        file = File.open(@@output_dir + "parameters_#{obj.id}.csv",'w+')
        output_table_yx(file,obj.parameters)
      ensure
        file.close() unless file.nil?
      end
    end
  end

  def items()
    rxdata_to_csv('Items.rxdata','Items.csv')
  end

  def skills()
    rxdata_to_csv('Skills.rxdata','Skills.csv')
  end

  def enemies()
    rxdata_to_csv('Enemies.rxdata','Enemies.csv')
  end

  def states()
    rxdata_to_csv('States.rxdata','States.csv')
  end

  def classes()
    rxdata_to_csv('Classes.rxdata','Classes.csv')
  end

  def troops()
    rxdata_to_csv('Troops.rxdata','Troops.csv')
  end

  def weapons()
    rxdata_to_csv('Weapons.rxdata','Weapons.csv')
  end

  def armors()
    rxdata_to_csv('Armors.rxdata','Armors.csv')
  end
end

$LOAD_PATH.push('../xp/rgss-lib')

require 'debug/rgss_base.rb'

Data_Export.data_dir = 'test/original_data/'
Data_Export.output_dir = 'output/'
#Data_Export.actors()
#Data_Export.items()
#Data_Export.skills()
#Data_Export.enemies()
#Data_Export.states()
#Data_Export.classes()
#Data_Export.troops()
#Data_Export.weapons()
#Data_Export.armors()
