# Window_Console
# EBhER\[
# Author:: fukuyama
# Date:: 2008/01/14
# Copyright:: Copyright (c) 2008 rgss-lib

class Window_Console < Window
  NORMAL_COLOR = Color.new(255,255,255,255)
  
  # LR\[
  @@_window_console = nil
  # R\[o͗p\bh
  def self.put(msg,color=NORMAL_COLOR)
    @@_window_console.push(msg,color) unless @@_window_console.nil?
  end
  # o͒H
  def self.output?
    return false if @@_window_console.nil?
    return @@_window_console.output?
  end
  
  # 
  def initialize
    super
    self.windowskin = RPG::Cache.windowskin("001-Blue01")
    self.x = 0
    self.y = 0
    self.width = 640
    self.height = 480
    self.z = 100
    self.visible = true
    self.active = true
    self.contents = Bitmap.new(self.width - 32,self.height - 32)
    @lines = []
    @line_colors = []
    @dx = 0
    @dy = 0
    @lh = 14
    self.contents.font.size = @lh - 2
    @mode = ""
    @@_window_console = self
    @speed = 10
  end
  
  # j
  def dispose
    @@_window_console = nil
    unless self.contents.nil?
      self.contents.dispose
    end
    super
  end
  
  # XV
  def update
    super
    update_contents
    if not output?
      case @mode
      when "menu"
        update_menu
      end
    end
  end
  
  # RecXV
  def update_contents
    for i in 1 .. @speed
      unless @lines.empty?
        line = @lines[0]
        self.contents.font.color = @line_colors[0]
        c = line.slice!(/./m)
        rect = self.contents.text_size(c)
        rect.x = @dx
        rect.y = @dy
        self.contents.draw_text(rect,c)
        @dx += rect.width
        if line.size == 0
          @dx = 0
          @dy += @lh
          @lines.shift
          @line_colors.shift
          if @dy >= self.contents.height
            src_rect = self.contents.rect
            src_rect.y = @lh
            src_bitmap = self.contents.dup
            self.contents.clear
            self.contents.blt(0,0,src_bitmap,src_rect)
            @dy -= @lh
            src_bitmap.dispose
          end
        end
      end
    end
  end
  
  # sǉ
  def push(line,color=NORMAL_COLOR)
    @lines.push line.dup
    @line_colors.push color
  end
  
  # o͒H
  def output?
    return (not @lines.empty?)
  end
  
  # j[
  def menu(menus)
    dy = @dy + @lh * @lines.size
    @mode = "menu"
    @menu_text_list = menus.dup
    @menu_rect_list = @menu_text_list.collect {|m| self.contents.text_size(m)}
    @menu_text_list.each {|m| push(m)}
    @menu_rect_list.inject(dy) {|y,r| r.y = y; y + @lh}
    @menu_index = 0
  end
  
  # j[XV
  def update_menu
    return unless @lines.empty?
    self.cursor_rect = @menu_rect_list[@menu_index]
    if Input::trigger?(Input::UP)
      @menu_index -= 1
      if @menu_index < 0
        @menu_index = 0
      end
    end
    if Input::trigger?(Input::DOWN)
      @menu_index += 1
      if @menu_rect_list.size <= @menu_index
        @menu_index = @menu_rect_list.size - 1
      end
    end
  end
  
  # [h`FbN
  def mode_menu?
    @mode == "menu"
  end
  
  # Ij[擾(j[I)
  def select_menu
    return if not mode_menu?
    result = @menu_text_list[@menu_index]
    @mode = ""
    @menu_text_list = nil
    @menu_rect_list = nil
    @menu_index = -1
    self.cursor_rect.empty
    return result
  end
end

