require 'debug/rpgxpdt_log'
require 'debug/rgss_base'
require 'tools/dbc/data_compiler'

module DBC
  class RXData_Value_Creator < Default_Value_Creator
    RANK_DATA = {
      'A' => 1,
      'B' => 2,
      'C' => 3,
      'D' => 4,
      'E' => 5,
      'F' => 6
    }

    def initialize(*args)
      super(*args)
      @enemy_actions = nil
    end

    def get_properties(key)
      self.compiler.get_properties(key)
    end

    def to_rank_map(value)
      rank_map = {}
      value.split(/\s+/).each() do |e|
      (key,rank) = e.split(/:/)
        next if key.nil? or rank.nil?
        if RANK_DATA.member?(rank)
          rank_map[key] = RANK_DATA[rank]
        else
          rank_map[key] = rank.to_i
        end
      end
      rank_map
    end
    private :to_rank_map

    def to_id_array(value,prop)
      result = value.split(/\s+/).collect() do |v|
        if prop[v].nil?
          if v =~ /^[0-9]+$/
            v
          else
            nil
          end
        else
          prop[v]['id']
        end
      end
      result.compact
    end
    private :to_id_array

    def create_value_audio(key_name,key_type,value)
      args = value.split(/\s+/)
      if not args[1].nil?
        args[1] = args[1].to_i
      end
      if not args[2].nil?
        args[2] = args[2].to_i
      end
      ::RPG::AudioFile.new(*args)
    end

    def create_value_state_ranks(key_name,key_type,value)
      rank_map = to_rank_map(value)
      states = get_properties('States')['id']
      t = Table.new(states.size + 1)
      states.keys().sort().each() do |i|
        name = states[i]['name']
        if (not name.nil?) and (not name.empty?) and rank_map.member?(name)
          t[i] = rank_map[name]
        else
          t[i] = 3
        end
      end
      t
    end

    def create_value_element_ranks(key_name,key_type,value)
      rank_map = to_rank_map(value)
      elements = get_properties('Elements')['id']
      t = Table.new(elements.size + 1)
      elements.keys().sort().each() do |i|
        name = elements[i]['name']
        if (not name.nil?) and (not name.empty?) and rank_map.member?(name)
          t[i] = rank_map[name]
        else
          t[i] = 3
        end
      end
      t
    end

    def create_value_state_set(key_name,key_type,value)
      states = get_properties('States')['name']
      to_id_array(value,states)
    end

    def create_value_element_set(key_name,key_type,value)
      elements = get_properties('Elements')['name']
      to_id_array(value,elements)
    end

    def create_value_skill_id(key_name,key_type,value)
      skills = get_properties('Skills')['name']
      if value =~ /^[0-9]+$/
        return value.to_i
      else
        return skills[value]['id']
      end
    end

    def create_value_actions(key_name,key_type,value)
      if @enemy_actions.nil?
        @enemy_actions = self.compiler.load_object('EnemyActions')['RPG::Enemy::Action']['name']
      end
      actions = []
      if not @enemy_actions.nil?
        value.split(/\s+/).each do |v|
        (name,rating) = v.split(/:/)
          if @enemy_actions.key?(name)
            action = Marshal.load(Marshal.dump(@enemy_actions[name]))
            if not rating.nil?
              action.rating = rating.to_i()
            end
            actions.push(action)
          end
        end
      end
      actions
    end

    def create_value_equip_set(data,value)
      equip = 'equip_' + value
      result = []
      data.keys().sort().each() do |id|
        o = data[id]
        if not o[equip].nil?
          result.push(id)
        end
      end
      result
    end

    def create_value_weapon_set(key_name,key_type,value)
      data = get_properties('Weapons')['id']
      create_value_equip_set(data,value)
    end

    def create_value_armor_set(key_name,key_type,value)
      data = get_properties('Armors')['id']
      create_value_equip_set(data,value)
    end

    def create_value_learnings(key_name,key_type,value)
      skills = get_properties('Skills')['id']
      learn = key_name + '_' + value
      result = []
      skills.keys().sort().each() do |id|
        skill = skills[id]
        if not skill[learn].nil?
          l = RPG::Class::Learning.new
          l.level = skill[learn]
          l.skill_id = id
          result.push(l)
        end
      end
      result
    end

    def create_value_parameters(key_name,key_type,value)
      m = get_properties(value)['lv']
      t = Table.new(6,100)
      for i in 1..99
        t[0,i] = m[i]['hp']
        t[1,i] = m[i]['mp']
        t[2,i] = m[i]['str']
        t[3,i] = m[i]['dex']
        t[4,i] = m[i]['age']
        t[5,i] = m[i]['int']
      end
      t
    end
  end
end