/**
 * Copyright (C) 2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.common;

import java.math.BigDecimal;
import java.text.DecimalFormat;

/**
 * Doublep[eBeB
 * 
 * @since 2.05
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class UtilDouble {

	/**
	 * [eBeBNX̂߃RXgN^͌J܂B
	 * 
	 * @since 2.05
	 */
	private UtilDouble() {
	}
	
	/**
	 * œnꂽ񂩂J}A^[R[hAXy[X菜doubleɕϊ܂
	 * 
	 * @since 2.05
	 * @param p_src ϊ
	 * @return ϊ̐l
	 * @throws NumberFormatException lւ̕ϊɎsꍇ
	 */
	public static double parseDouble(String p_src) throws NumberFormatException {
		String s = p_src.replaceAll(",","");
		s = s.replaceAll("\r","");
		s = s.replaceAll("\n","");
		double returnValue = Double.parseDouble(s.trim());
		return returnValue;
	}

	/**
	 * ľܓ܂Bp_src0.015p_scale2w肷0.02Ԃ܂B
	 * 
	 * @since 2.05
	 * @param p_src ľܓO̒l
	 * @param p_scale ľܓ̏_ȉ̌
	 * @return ľܓ̒l
	 */
	public static double round(double p_src, int p_scale) {
		BigDecimal bd = new BigDecimal(String.valueOf(p_src));
		double returnValue = bd.setScale(p_scale, BigDecimal.ROUND_HALF_UP).doubleValue();
		return returnValue;
	}

	/**
	 * ؎̂Ă܂Bp_src0.015p_scale2w肷0.01Ԃ܂B
	 * 
	 * @since 2.60
	 * @param p_src ؎̂đO̒l
	 * @param p_scale ؎̂Č̏_ȉ̌
	 * @return ؎̂Č̒l
	 */
	public static double fix(double p_src, int p_scale) {
		BigDecimal bd = new BigDecimal(String.valueOf(p_src));
		double returnValue = bd.setScale(p_scale, BigDecimal.ROUND_DOWN).doubleValue();
		return returnValue;
	}

	/**
	 * ؏グ܂Bp_src0.014p_scale2w肷0.02Ԃ܂B
	 * 
	 * @since 2.60
	 * @param p_src ؏グO̒l
	 * @param p_scale ؏グ̏_ȉ̌
	 * @return ؏グ̒l
	 */
	public static double ceil(double p_src, int p_scale) {
		BigDecimal bd = new BigDecimal(String.valueOf(p_src));
		double returnValue = bd.setScale(p_scale, BigDecimal.ROUND_UP).doubleValue();
		return returnValue;
	}

	/**
	 * double^̒l𕶎ŕԂ܂Bw`0.00`ɕϊĕԂ܂B
	 * 
	 * @since 2.05
	 * @param p_src ϊ̐l
	 * @param p_scale ϊ̏_ȉ̌
	 * @return w肵doublel̕\
	 */
	public static String format(double p_src, int p_scale) {
		String pattern = "";
		if (p_scale<=0) {
			pattern = "0";
		} else {
			pattern = "0.";
			for (int i=0;i<p_scale;i++) {
				pattern += "0";
			}
		}
		DecimalFormat fmt = new DecimalFormat(pattern);
		return fmt.format(p_src);
	}

	/**
	 * w肵l̏_ȉ̌Ԃ܂B
	 * 
	 * @since 2.80
	 * @param p_src Ώۂ̐lB
	 * @param p_maxLength _ȉ̍ő包B̌̌͐؂̂ĂČvZ܂B
	 * @return _ȉ̌
	 */
	public static int getScaleLength(double p_src, int p_maxLength) {
		String src = format(p_src, p_maxLength);
		return UtilString.getScaleLength(src);
	}

	/**
	 * w肵l̏ōŏ1ȏ̐l錅Ԃ܂B<br>
	 * ij0.000123  4Ԃ
	 * 
	 * @since 2.80
	 * @param p_src Ώۂ̐lB
	 * @return w肵l̏ōŏ1ȏ̐l錅
	 */
	public static int getScaleHeadLength(double p_src) {
		if (p_src==0) return 0;
		int returnValue = 0;
		double wSrc = p_src;
		while (true) {
			if (wSrc>=1) {
				break;
			}
			wSrc = wSrc * 10;
			++returnValue;
		}
		return returnValue;
	}
	
}
