/**
 * Copyright (C) 2012 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.ui.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

import jp.robotbrain.common.UtilDouble;
import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.NmViewType;
import jp.robotbrain.signal.CoreFramework;
import jp.robotbrain.signal.Tag;

/**
 * Ot\pl
 * 
 * @since 2.60
 * @author Copyright (C) 2012 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class GraphPanel extends JPanel{
	
	/**
	 * VAo[WID
	 *  
	 * @since 2.60
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * OtC̃XgiOC^[tF[Xj
	 *  
	 * @since 2.60
	 */
	private GraphLayerList m_graphLayerList;

	/**
	 * OtC̃Xgi`pj
	 *  
	 * @since 2.60
	 */
	private GraphLayerList m_paintGraphLayerList;
	
	/**
	 * eNjJwWP̕
	 *  
	 * @since 2.80
	 */
	private int m_indexWidth;

	/**
	 * J[\̐F
	 *  
	 * @since 2.60
	 */
	private Color m_cursorColor;

	/**
	 * J[\XW
	 *  
	 * @since 2.60
	 */
	private int m_cursorX;
	
	/**
	 * eNjJwW̐̑
	 *  
	 * @since 2.60
	 */
	private float m_lineWidth;

	/**
	 * ڐ̐F
	 *  
	 * @since 2.60
	 */
	private Color m_rulerColor;
	
	/**
	 * TuChbO̘gF
	 *  
	 * @since 2.80
	 */
	private Color m_subLayerRectColor;
	
	/**
	 * ^Cgo[̔wiF
	 *  
	 * @since 2.60
	 */
	private Color m_titleBarBackColor;

	/**
	 * ^Cgo[̕F
	 *  
	 * @since 2.60
	 */
	private Color m_titleBarForeColor;
	
	/**
	 * Ot\ĂȂԂ̎ɕ\郁bZ[W̕F
	 *  
	 * @since 2.80
	 */
	private Color m_emptyMessageForeColor;
	
	/**
	 * vڍ׏񂪋L^ꂽC
	 * 
	 * @since 2.60
	 */
	private IndexObjectList<IndexPoint> m_statusLine;
	
	/**
	 * ^Cgo[̃tHg
	 * 
	 * @since 2.80
	 */
	private Font m_titleBarFont;

	/**
	 * ڐ̃tHg
	 * 
	 * @since 2.80
	 */
	private Font m_rulerFont;
	
	/**
	 * Ot\ĂȂԂ̎ɕ\郁bZ[W̃tHg
	 * 
	 * @since 2.80
	 */
	private Font m_emptyMessageFont;

	/**
	 * VOi{bNX
	 * 
	 * @since 2.80
	 */
	private CoreFramework m_signalBox;

	/**
	 * CC̍̔䗦BŜ̉B
	 * 
	 * @since 2.80
	 */
	private int m_mainLayerHeightRatio;
	
	/**
	 * TuChbO̘g\邩
	 *  
	 * @since 2.80
	 */
	private boolean m_showSubLayerRect;

	/**
	 * C̏[^Cgo[[܂ł̋
	 * 
	 * @since 2.80
	 */
	private int m_titleBarTopOffset;
	
	/**
	 * C̉[eNjJwW`GA[܂ł̋
	 * 
	 * @since 2.80
	 */
	private int m_indexBottomOffset;
	
	/**
	 * CxgXi[Xg
	 * 
	 * @since 2.80
	 */
	private EventListenerList m_eventListenerList;

	/**
	 * Ot\ĂȂԂ̏ꍇtrue
	 * 
	 * @since 2.80
	 */
	private boolean m_empty;

	/**
	 * ĕ`OɃOt\ĂȂԂꍇtrue
	 * 
	 * @since 2.80
	 */
	private boolean m_prevEmpty;

	/**
	 * Ot\ĂȂԂ̎ɕ\郁bZ[W
	 * 
	 * @since 2.80
	 */
	private String m_emptyMessage;
	
	/**
	 * GraphPanel𐶐܂B
	 * 
	 * @since 2.60
	 */
	public GraphPanel() {
		super();
		setBorder(null);
		m_graphLayerList = new GraphLayerList(this);
		m_paintGraphLayerList = new GraphLayerList(this);
		m_indexWidth = 3;
		m_cursorX = -1;
		m_lineWidth = 1;
		m_cursorColor = Color.PINK;
		m_rulerColor = new Color(153, 153, 102);
		m_titleBarBackColor = new Color(102, 153, 51);
		m_titleBarForeColor = Color.WHITE;
		m_mainLayerHeightRatio = 70;
		m_subLayerRectColor = Color.YELLOW;
		m_showSubLayerRect = false;
		m_titleBarTopOffset = 5;
		m_indexBottomOffset = 5;
		m_eventListenerList = new EventListenerList();
		m_empty = true;
		m_prevEmpty = true;
	}

	/**
	 * Ot摜t@Cɏo͂܂B
	 * 
	 * @since 3.00
	 * @param p_imageFilePath 摜t@C̃pX
	 * @param p_imageFormat 摜̌`("jpeg","gif","png"Ȃ)
	 * @throws IOException 摜t@C̏o͂Ɏsꍇ
	 */
	public void writeImage(String p_imageFilePath, String p_imageFormat) throws IOException {
	    BufferedImage bufImage = (BufferedImage) createImage(getWidth(), getHeight());
	    Graphics bufGraphics = bufImage.createGraphics();
	    bufGraphics.setColor(getBackground());
	    bufGraphics.fillRect(0, 0, getWidth(), getHeight());
		paintGraph(bufGraphics);
		ImageIO.write(bufImage, "png", new File(p_imageFilePath));
	}
	
	/**
	 * Ot`悵܂B
	 * 
	 * @since 3.00
	 * @param p_graphics Graphics̃CX^X
	 */
	@Override
	protected void paintComponent(Graphics p_graphics) {
		super.paintComponent(p_graphics);
		paintGraph(p_graphics);
	}
	
	/**
	 * Ot`悵܂B
	 * 
	 * @since 3.00
	 * @param p_graphics Graphics̃CX^X
	 */
	public void paintGraph(Graphics p_graphics){
		Graphics2D graphics2D = (Graphics2D)p_graphics;
    	try {
			m_empty = true;
			if (m_paintGraphLayerList.getValues().size()<=0) return;
			// C
			Font fontBackup = p_graphics.getFont();
			if (m_rulerFont!=null) p_graphics.setFont(m_rulerFont);
			for (GraphLayer layer: m_paintGraphLayerList.getValues()) {
				layer.setPrevTag(null);
				layer.setIndexTopOffset(getFontHeight(graphics2D));
			}
			p_graphics.setFont(fontBackup);
			GraphLayer mainLayer = getPaintMainLayer();
			if (mainLayer==null) return;
			if (mainLayer.getPaintSrcList().size()<2) return;
			// `Jn
			m_empty = false;
			// ڐ`
			int top = 0;
			GraphLayer prevLayer = null;
			for (int i=0;i<m_paintGraphLayerList.getValues().size();i++) {
				GraphLayer layer = m_paintGraphLayerList.getValues().get(i);
				if (prevLayer!=null && (layer.getLayerNo()<0 || layer.getLayerNo()!=prevLayer.getLayerNo())) {
					// Cԍ؂ւꍇxWɂ炷
					top += getHeight() * prevLayer.getHeightRatio() / 100;
				}
				if (layer.getRuler().isVisible()) {
					// `
					layer.setTop(top);
			    	drawRulerAndTitleBar(graphics2D, layer);
				}
				// lۑ
				prevLayer = layer;
			}
			// J[\`
			drawCursor(graphics2D);
			// TuChbO̘g`
			if (m_showSubLayerRect) drawSubLayerRect(graphics2D);
			// eNjJwW`
			for (int i=0;i<mainLayer.getPaintSrcList().size();i++) {
				IndexObject main = mainLayer.getPaintSrcList().get(i);
				top = 0;
				prevLayer = null;
				for (GraphLayer layer: m_paintGraphLayerList.getValues()) {
					if (prevLayer!=null && (layer.getLayerNo()<0 || layer.getLayerNo()!=prevLayer.getLayerNo())) {
						// Cԍ؂ւꍇxWɂ炷
			    		top += getHeight() * prevLayer.getHeightRatio() / 100;
					}
					// `
					layer.setTop(top);
					if (layer.getPaintSrcList().getViewType()==NmViewType.INDEXLINE || layer.getPaintSrcList().getViewType()==NmViewType.INDEXLINE_PERCENTAGE) {
			    		drawIndexLine(graphics2D, layer, main.getTag());
					} else if (layer.getPaintSrcList().getViewType()==NmViewType.CANDLESTICKLIST) {
			    		drawCandleStickList(graphics2D, layer, main.getTag());
					}
			    	// lۑ
			    	prevLayer = layer;
				}
			}
		} finally {
			if (m_empty) {
				// Ot\ĂȂꍇ̓bZ[W\
				drawEmptyMessage(graphics2D);
			}
			if (m_empty!=m_prevEmpty) {
				// \eύXCxg𔭐
				fireGraphUpdatedEvent();
				m_prevEmpty = m_empty;
			}
			// 
			graphics2D.dispose();
		}
    }

    /**
     * CxgXi[ǉ܂B
     * 
	 * @since 2.80
     * @param p_listener CxgXi[
     */
    public void addUpdatedListener(GraphListener p_listener) {
    	m_eventListenerList.add(GraphListener.class, p_listener);
    }

    /**
     * CxgXi[폜܂B
     * 
	 * @since 2.80
     * @param p_listener CxgXi[
     */
    public void removeUpdatedListener(GraphListener p_listener) {
    	m_eventListenerList.remove(GraphListener.class, p_listener);
    }
   
    /**
     * Ot̕\eςƂm点Cxg𔭐܂B
     * 
	 * @since 2.80
     */
    protected void fireGraphUpdatedEvent() {
    	  Object[] listenerList = m_eventListenerList.getListenerList();
    	  GraphEvent event = new GraphEvent(this);
    	  for(int i = listenerList.length-2; i>=0; i-=2) {
    	    if(listenerList[i]==GraphListener.class) {
    	      ((GraphListener)listenerList[i+1]).updated(event);
    	    }
    	  }
   	}   
    
    /**
	 * `pCCԂ܂B
	 *  
	 * @since 2.60
     * @return `pCC
     */
    private GraphLayer getPaintMainLayer() {
    	if (m_paintGraphLayerList.getValues().size()<=0) return null;
    	return m_paintGraphLayerList.getValues().get(0);
    }
   
    /**
     * OC^[tF[XpCCԂ܂B
     * 
	 * @since 2.60
     * @return	OC^[tF[XpCC
     */
    protected GraphLayer getMainLayer() {
    	if (m_graphLayerList.getValues().size()<=0) return null;
    	return m_graphLayerList.getValues().get(0);
    }
    
    /**
     * J[\`悵܂B
     * 
	 * @since 2.60
     * @param p_graphics2D Graphics2DCX^X
     */
    private void drawCursor(Graphics2D p_graphics2D) {
    	if (m_cursorX>0) {
    	    BasicStroke stroke = new BasicStroke(1.0f);
    	    p_graphics2D.setStroke(stroke);
    	    p_graphics2D.setColor(m_cursorColor);
    		p_graphics2D.fillRect(getCursorXPointCount()*m_indexWidth, 0, m_indexWidth, getHeight());
    	}
    }

    /**
     * TuChbO̘g`悵܂B
     * 
	 * @since 2.80
     * @param p_graphics2D Graphics2DCX^X
     */
    private void drawSubLayerRect(Graphics2D p_graphics2D) {
	    BasicStroke stroke = new BasicStroke(2.0f);
	    p_graphics2D.setStroke(stroke);
	    p_graphics2D.setColor(m_subLayerRectColor);
		int y = (int)(getHeight() * m_mainLayerHeightRatio / 100);
		p_graphics2D.drawRect(2, y+m_titleBarTopOffset+5, getWidth()-5, getHeight()*(100-m_mainLayerHeightRatio)/100-m_titleBarTopOffset-7);
    }
 
    /**
     * w肳ꂽ̕(hbg)Ԃ܂B
     * 
	 * @since 2.60
     * @param p_graphics2D Graphics2DCX^X
     * @param p_value 
     * @return w肳ꂽ̕(hbg)
     */
    private int calcStringWidth(Graphics2D p_graphics2D, String p_value) {
    	FontMetrics fm = p_graphics2D.getFontMetrics();
    	int returnValue = 0;
    	for(int j=0; j<p_value.length(); j++) {
    		returnValue += fm.charWidth(p_value.charAt(j));
    	}
    	return returnValue;
    }

    /**
     * ̍Ԃ܂B
     * 
	 * @since 2.60
     * @param p_graphics2D Graphics2DCX^X
     * @return ̍
     */
    private int getFontHeight(Graphics2D p_graphics2D) {
    	FontMetrics fm = p_graphics2D.getFontMetrics();
    	return fm.getHeight();
    }
  
    /**
     * Ot\ĂȂԂ̎ɕ\郁bZ[W`悵܂B
     * 
	 * @since 2.80
     * @param p_graphics2D Graphics2DCX^X
     */
    private void drawEmptyMessage(Graphics2D p_graphics2D) {
    	if (m_emptyMessage==null) return;
		Font fontBackup = p_graphics2D.getFont();
		if (m_emptyMessageFont!=null) p_graphics2D.setFont(m_emptyMessageFont);
		if (m_emptyMessageForeColor!=null) p_graphics2D.setColor(m_emptyMessageForeColor);
		int viewStringWidth = calcStringWidth(p_graphics2D,m_emptyMessage);
		p_graphics2D.drawString(m_emptyMessage, getWidth()/2-viewStringWidth/2, getHeight()/2);
		p_graphics2D.setFont(fontBackup);
    }
		
    /**
     * ڐƃ^Cgo[`悵܂B
     * 
	 * @since 2.60
     * @param p_graphics2D Graphics2DCX^X
     * @param p_layer CCX^X
     */
    private void drawRulerAndTitleBar(Graphics2D p_graphics2D, GraphLayer p_layer) {
    	// ^Cgo[`
    	BasicStroke stroke = new BasicStroke(1.0f);
	    p_graphics2D.setStroke(stroke);
		p_graphics2D.setColor(m_titleBarBackColor);
		int titleBarTop = p_layer.getTitleBarTop();
		p_graphics2D.fillRect(0, titleBarTop, getWidth(), p_layer.getTitleBarHeight());
		if (!p_layer.getTitle().isEmpty()) {
			// ^Cg`
			Font fontBackup = p_graphics2D.getFont();
			if (m_titleBarFont!=null) p_graphics2D.setFont(m_titleBarFont);
			int fontHeight = getFontHeight(p_graphics2D);
			int fontAscent = p_graphics2D.getFontMetrics().getAscent();
			p_graphics2D.setColor(m_titleBarForeColor);
			int titleOffset = (p_layer.getTitleBarHeight() - fontHeight) / 2;
			if (titleOffset<0) titleOffset = 0;
			p_graphics2D.drawString(p_layer.getTitle(), 4, titleBarTop + titleOffset + fontAscent);
			p_graphics2D.setFont(fontBackup);
		}
	    // ڐ`
		float dash[] = {2.0f, 3.0f};
	    stroke = new BasicStroke(1.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER, 10.0f, dash, 0.0f);
	    p_graphics2D.setStroke(stroke);
		p_graphics2D.setColor(m_rulerColor);
		if (p_layer.getRuler().getStep()<=0) return;
		for (double i=p_layer.getRuler().getMax(); i>=p_layer.getRuler().getMin(); i-=p_layer.getRuler().getStep()) {
			// `
			int y = p_layer.calcY(i, getHeight());
			p_graphics2D.drawLine(0, y, getWidth(), y);
			// l`
			Font fontBackup = p_graphics2D.getFont();
			if (m_rulerFont!=null) p_graphics2D.setFont(m_rulerFont);
			int fontHeight = getFontHeight(p_graphics2D);
			int fontAscent = p_graphics2D.getFontMetrics().getAscent();
			String viewString = UtilDouble.format(i, p_layer.getRuler().getScale());
			int viewStringWidth = calcStringWidth(p_graphics2D,viewString);
			int stringY = y - fontHeight + fontAscent;
			// ʒ̖ڐ
			p_graphics2D.drawString(viewString, getWidth()/3-viewStringWidth, stringY);
			// ʉE[̖ڐ
			p_graphics2D.drawString(viewString, getWidth()-viewStringWidth-10, stringY);
			p_graphics2D.setFont(fontBackup);
		}
    }
    
    /**
     * eNjJwW̐`悵܂B
     * 
	 * @since 2.60
     * @param p_graphics2D Graphics2DCX^X
     * @param p_layer CCX^X
     * @param p_mainLayerTag CC̃eNjJwW̃^O
     */
    private void drawIndexLine(Graphics2D p_graphics2D, GraphLayer p_layer, Tag p_mainLayerTag) {
		// eNjJwW𓾂
		IndexPoint current = (IndexPoint)p_layer.getPaintSrcList().get(p_mainLayerTag);
		if (current==null) return;
		IndexPoint prev = (IndexPoint)p_layer.getPaintSrcList().get(p_layer.getPrevTag());
		if (prev==null) {
			p_layer.setPrevTag(p_mainLayerTag);
			return;
		}
		// Ԗڂ̃^Oׂ(CCɑ)
		int prevPointer = getPaintMainLayer().getPaintSrcList().indexOf(prev) + 1;
		int currentPointer = getPaintMainLayer().getPaintSrcList().indexOf(current) + 1;
		// XWvZ
		int prevX = prevPointer * m_indexWidth;
		int currentX = currentPointer * m_indexWidth;
		// YWvZ
		int prevY = p_layer.calcY(prev.getValue(),getHeight());
		int currentY = p_layer.calcY(current.getValue(),getHeight());
	    // ̑`
	    BasicStroke stroke = new BasicStroke(m_lineWidth);
	    p_graphics2D.setStroke(stroke);
	    // FI
	    if (p_layer.isStatusColor() && m_statusLine!=null) {
	    	// vJ[
    		IndexPoint status = m_statusLine.get(p_mainLayerTag);
    		if (status!=null) {
        		p_graphics2D.setColor(status.getColor());
    		}
	    } else {
	    	IndexObject indexObject = p_layer.getPaintSrcList().get(p_mainLayerTag);
	    	if (indexObject!=null && indexObject.getColor()!=null) {
		    	// eNjJwWwWJ[
				p_graphics2D.setColor(indexObject.getColor());
	    	} else {
		    	// CJ[
				p_graphics2D.setColor(p_layer.getForeColor());
	    	}
	    }
	    // eNjJwW`悷
		p_graphics2D.drawLine(prevX, prevY, currentX-1, currentY);
		p_layer.setPrevTag(p_mainLayerTag);
    }
 
    /**
     * [\Ñ`[g`悵܂B
     * 
	 * @since 2.60
     * @param p_graphics2D Graphics2DCX^X
     * @param p_layer CCX^X
     * @param p_mainLayerTag CC̃eNjJwW̃^O
     */
    private void drawCandleStickList(Graphics2D p_graphics2D, GraphLayer p_layer, Tag p_mainLayerTag) {
		// eNjJwW𓾂
		CandleStick current = (CandleStick)p_layer.getPaintSrcList().get(p_mainLayerTag);
		if (current==null) return;
		// Ԗڂ̃^Oׂ(CCɑ)
		int currentPointer = getPaintMainLayer().getPaintSrcList().indexOf(current);
		// WvZ
		int currentX = currentPointer * m_indexWidth;
		int currentY = 0;
		int height = 0;
		int higeHighY = -1;
		int higeLowY = -1;
		Color fillColor = Color.WHITE;
		if (current.getOpen()<=current.getClose()) {
			// z\
			// [\N̍WvZ
			currentY = p_layer.calcY(current.getClose(),getHeight());
			height = p_layer.calcYDistance(current.getClose() - current.getOpen(),getHeight());
			fillColor = current.getPlusColor();
			// qQ̍WvZ
			if (current.getHigh()>current.getClose()) {
				higeHighY = p_layer.calcY(current.getHigh(),getHeight());
			}
			if (current.getLow()<current.getOpen()) {
				higeLowY = p_layer.calcY(current.getLow(),getHeight());
			}
		} else {
			// A
			// [\N̍WvZ
			currentY = p_layer.calcY(current.getOpen(),getHeight());
			height = p_layer.calcYDistance(current.getOpen() - current.getClose(),getHeight());
			fillColor = current.getMinusColor();
			// qQ̍WvZ
			if (current.getHigh()>current.getOpen()) {
				higeHighY = p_layer.calcY(current.getHigh(),getHeight());
			}
			if (current.getLow()<current.getClose()) {
				higeLowY = p_layer.calcY(current.getLow(),getHeight());
			}
		}
	    // [\N`悷
	    BasicStroke stroke = new BasicStroke(m_lineWidth);
	    p_graphics2D.setStroke(stroke);
	    // [\N̘g`
	    // FI
	    if (p_layer.isStatusColor() && m_statusLine!=null) {
	    	// vJ[
    		IndexPoint status = m_statusLine.get(p_mainLayerTag);
    		if (status!=null) {
        		p_graphics2D.setColor(status.getColor());
    		}
	    } else {
	    	IndexObject indexObject = p_layer.getPaintSrcList().get(p_mainLayerTag);
	    	if (indexObject!=null && indexObject.getColor()!=null) {
		    	// eNjJwWwWJ[
				p_graphics2D.setColor(indexObject.getColor());
	    	} else {
		    	// CJ[
				p_graphics2D.setColor(p_layer.getForeColor());
	    	}
	    }
		p_graphics2D.drawRect(currentX, currentY, m_indexWidth-1, height);
		// qQ`
		int higeX = currentX + m_indexWidth / 2;
		if (higeHighY>0) {
			p_graphics2D.drawLine(higeX, currentY, higeX, higeHighY);
		}
		if (higeLowY>0) {
			p_graphics2D.drawLine(higeX, currentY, higeX, higeLowY);
		}
	    // [\N̒hԂ
		p_graphics2D.setColor(fillColor);
		int fillOffset = (int)Math.round(m_lineWidth/2); 
		int lineWidth = (int)m_lineWidth;
		p_graphics2D.fillRect(currentX+fillOffset, currentY+fillOffset, m_indexWidth-lineWidth-1, height-lineWidth*1);
		p_layer.setPrevTag(p_mainLayerTag);
    }

    /**
     * J[\XWeNjJwW̌ɊZlԂ܂B
     * 
	 * @since 2.60
     * @return J[\XWeNjJwW̌ɊZl
     */
    public int getCursorXPointCount() {
    	return (int)(m_cursorX / m_indexWidth);
    }
  
    /**
     * pl̉eNjJwW̌ɊZlԂ܂B
     * 
	 * @since 2.60
     * @return pl̉eNjJwW̌ɊZl
     */
    public int getWidthPointCount() {
    	return (int)(getWidth() / m_indexWidth);
    }
    
    /**
     * CC̃J[\ʒuԂ܂B
     * 
	 * @since 2.60
     * @return CC̃J[\ʒu
     */
    public IndexObject getCursorPoint() {
    	GraphLayer mainLayer = getPaintMainLayer();
    	if (mainLayer==null) return null;
    	IndexObject src;
    	if (mainLayer.getPaintSrcList().size()<=getWidthPointCount()) {
    		// ׂĂ̒l\Ăꍇ
        	src = mainLayer.getPaintSrcList().get(getCursorXPointCount());
    	} else {
    		// ׂĂ̒l\ł[̒l\Ăꍇ
        	int tailIndex = getWidthPointCount() - getCursorXPointCount();
        	if (mainLayer.getPaintSrcList().size()<=tailIndex) return null;
        	src = mainLayer.getPaintSrcList().get(mainLayer.getPaintSrcList().size()-tailIndex);
    	}
    	if (src==null) return null;
    	if (m_statusLine==null) {
        	return src;
    	} else {
        	return m_statusLine.get(src.getTag());
    	}
    }
 
    /**
     * CC̍Ō̒lԂ܂B
     * 
	 * @since 2.80
     * @return CC̍Ō̒l
     */
    public IndexObject getLastPoint() {
    	GraphLayer mainLayer = getPaintMainLayer();
    	if (mainLayer==null) return null;
    	return mainLayer.getPaintSrcList().getLast();
    }
 
    /**
     * J[\ʒuЂƂߋijɈړ܂B
     * 
	 * @since 2.60
     */
    public void movePrevCursor() {
    	if (m_cursorX - m_indexWidth > 0) {
        	m_cursorX -= m_indexWidth;
    	}
    }

    /**
     * J[\ʒuЂƂiEjɈړ܂B
     * 
	 * @since 2.60
     */
    public void moveNextCursor() {
    	if (m_cursorX + m_indexWidth < getWidth()) {
        	m_cursorX += m_indexWidth;
    	}
    }
  
    /**
	 * J[\̂wWԂ܂B
	 * 
	 * @since 2.80
     * @return J[\̂wW
     */
    public int getCursorX() {
		return m_cursorX;
	}

	/**
	 * J[\̂wWݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_cursorX J[\̂wW
	 */
	public void setCursorX(int p_cursorX) {
		m_cursorX = p_cursorX;
	}

	/**
	 * J[\̐FԂ܂B
	 * 
	 * @since 2.60
	 * @return J[\̐F
	 */
	public Color getCursorColor() {
		return m_cursorColor;
	}

	/**
	 * J[\̐Fݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_cursorColor J[\̐F
	 */
	public void setCursorColor(Color p_cursorColor) {
		m_cursorColor = p_cursorColor;
	}

	/**
	 * eNjJwWP̕Ԃ܂B
	 *  
	 * @since 2.80
	 * @return eNjJwWP̕
	 */
	public int getIndexWidth() {
		return m_indexWidth;
	}

	/**
	 * eNjJwWP̕ݒ肵܂B
	 *  
	 * @since 2.80
	 * @param p_pointWidth eNjJwWP̕
	 */
	public void setIndexWidth(int p_pointWidth) {
		m_indexWidth = p_pointWidth;
	}

	/**
	 * eNjJwW̐̑Ԃ܂B
	 * 
	 * @since 2.60
	 * @return eNjJwW̐̑
	 */
	public float getLineWidth() {
		return m_lineWidth;
	}

	/**
	 * eNjJwW̐̑ݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_lineWidth eNjJwW̐̑
	 */
	public void setLineWidth(float p_lineWidth) {
		m_lineWidth = p_lineWidth;
	}
	
	/**
	 * ڐ̐FԂ܂B
	 * 
	 * @since 2.60
	 * @return ڐ̐F
	 */
	public Color getRulerColor() {
		return m_rulerColor;
	}

	/**
	 * ڐ̐Fݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_rulerColor ڐ̐F
	 */
	public void setRulerColor(Color p_rulerColor) {
		m_rulerColor = p_rulerColor;
	}

	/**
	 * ^Cgo[̔wiFԂ܂B
	 * 
	 * @since 2.60
	 * @return ^Cgo[̔wiF
	 */
	public Color getTitleBarBackColor() {
		return m_titleBarBackColor;
	}

	/**
	 * ^Cgo[̔wiFݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_titleBarBackColor ^Cgo[̔wiF
	 */
	public void setTitleBarBackColor(Color p_titleBarBackColor) {
		m_titleBarBackColor = p_titleBarBackColor;
	}

	/**
	 * ^Cgo[̕FԂ܂B
	 * 
	 * @since 2.60
	 * @return ^Cgo[̕F
	 */
	public Color getTitleBarForeColor() {
		return m_titleBarForeColor;
	}

	/**
	 * ^Cgo[̕Fݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_titleBarForeColor ^Cgo[̕F
	 */
	public void setTitleBarForeColor(Color p_titleBarForeColor) {
		m_titleBarForeColor = p_titleBarForeColor;
	}

	/**
	 * ^Cgo[̃tHgԂ܂B
	 * 
	 * @since 2.80
	 * @return ^Cgo[̃tHg
	 */
	public Font getTitleBarFont() {
		return m_titleBarFont;
	}

	/**
	 * ^Cgo[̃tHgݒ肵܂B
	 * 
	 * @since 2.80
	 * @param p_titleBarFont ^Cgo[̃tHg
	 */
	public void setTitleBarFont(Font p_titleBarFont) {
		m_titleBarFont = p_titleBarFont;
	}

	/**
	 * ڐ̃tHgԂ܂B
	 * 
	 * @since 2.80
	 * @return ڐ̃tHg
	 */
	public Font getRulerFont() {
		return m_rulerFont;
	}

	/**
	 * ڐ̃tHgݒ肵܂B
	 * 
	 * @since 2.80
	 * @param p_rulerFont ڐ̃tHg
	 */
	public void setRulerFont(Font p_rulerFont) {
		m_rulerFont = p_rulerFont;
	}

	/**
	 * TuChbO̘gFԂ܂B
	 * 
	 * @since 2.80
	 * @return TuChbO̘gF
	 */
	public Color getSubLayerRectColor() {
		return m_subLayerRectColor;
	}

	/**
	 * TuChbO̘gFݒ肵܂B
	 * 
	 * @since 2.80
	 * @param p_subLayerRectColor TuChbO̘gF
	 */
	public void setSubLayerRectColor(Color p_subLayerRectColor) {
		m_subLayerRectColor = p_subLayerRectColor;
	}

	/**
	 * TuChbO̘g\邩Ԃ܂B
	 * 
	 * @since 2.80
	 * @return TuChbO̘g\邩
	 */
	public boolean isShowSubLayerRect() {
		return m_showSubLayerRect;
	}

	/**
	 * TuChbO̘g\邩ݒ肵܂B
	 * 
	 * @since 2.80
	 * @param p_showSubLayerRect TuChbO̘g\邩
	 */
	public void setShowSubLayerRect(boolean p_showSubLayerRect) {
		m_showSubLayerRect = p_showSubLayerRect;
	}

	/**
	 * C̏[^Cgo[[܂ł̋Ԃ܂B
	 * 
	 * @since 2.80
	 * @return C̏[^Cgo[[܂ł̋
	 */
	public int getTitleBarTopOffset() {
		return m_titleBarTopOffset;
	}

	/**
	 * C̏[^Cgo[[܂ł̋ݒ肵܂B
	 * 
	 * @since 2.80
	 * @param p_titleBarTopOffset C̏[^Cgo[[܂ł̋
	 */
	public void setTitleBarTopOffset(int p_titleBarTopOffset) {
		m_titleBarTopOffset = p_titleBarTopOffset;
	}

	/**
	 * C̉[eNjJwW`GA[܂ł̋Ԃ܂B
	 * 
	 * @since 2.80
	 * @return C̉[eNjJwW`GA[܂ł̋
	 */
	public int getIndexBottomOffset() {
		return m_indexBottomOffset;
	}

	/**
	 * C̉[eNjJwW`GA[܂ł̋ݒ肵܂B
	 * 
	 * @since 2.80
	 * @param p_indexBottomOffset C̉[eNjJwW`GA[܂ł̋
	 */
	public void setIndexBottomOffset(int p_indexBottomOffset) {
		m_indexBottomOffset = p_indexBottomOffset;
	}

	/**
	 * vڍ׏񂪋L^ꂽCԂ܂B
	 * 
	 * @since 2.60
	 * @param p_statusLine vڍ׏񂪋L^ꂽC
	 */
	public void setStatusLine(IndexObjectList<IndexPoint> p_statusLine) {
		m_statusLine = p_statusLine;
	}

	/**
	 * CC̍̔䗦Ԃ܂B
	 * 
	 * @since 2.80
	 * @return CC̍̔䗦BŜ̉B
	 */
	public int getMainLayerHeightRatio() {
		return m_mainLayerHeightRatio;
	}

	/**
	 * CC̍̔䗦ݒ肵܂B
	 * 
	 * @since 2.80
	 * @param p_mainLayerHeightRatio CC̍̔䗦BŜ̉B
	 */
	public void setMainLayerHeightRatio(int p_mainLayerHeightRatio) {
		m_mainLayerHeightRatio = p_mainLayerHeightRatio;
	}

	/**
	 * `̏܂B
	 * 
	 * @since 2.60
	 */
	public void preparePaint() {
		// `pCXg̐
		try {
			m_paintGraphLayerList = m_graphLayerList.clone();
			m_paintGraphLayerList.init();
		} catch (GraphException e) {
			e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		}
		// C̍
		if (m_paintGraphLayerList.getMaxLayerNo()>0) {
			// TuC
			for (int i=0;i<m_paintGraphLayerList.getValues().size();i++) {
				GraphLayer graphLayer = m_paintGraphLayerList.getValues().get(i); 
				int no = graphLayer.getLayerNo();
				if (no==0) {
					// Cԍ[
					graphLayer.setHeightRatio(m_mainLayerHeightRatio);
					if (i==0) {
						// CC	
						graphLayer.getRuler().setVisible(true);
					} else {
						// CCɃI[o[bvTuC
						graphLayer.getRuler().setVisible(false);
					}
				} else {
					// TuC
					int subLayerHeight = (100-m_mainLayerHeightRatio) / m_paintGraphLayerList.getMaxLayerNo();
					graphLayer.setHeightRatio(subLayerHeight);
					graphLayer.getRuler().setVisible(true);
				}
			}
		} else {
			// TuCȂ
			for (int i=0;i<m_paintGraphLayerList.getValues().size();i++) {
				GraphLayer graphLayer = m_paintGraphLayerList.getValues().get(i); 
				graphLayer.setHeightRatio(100);
				if (i==0) {
					// CC	
					graphLayer.getRuler().setVisible(true);
				} else {
					// CCɃI[o[bvTuC
					graphLayer.getRuler().setVisible(false);
				}
			}
		}
		// [[̓킹
		for (int i=0; i<m_paintGraphLayerList.getValues().size(); i++) {
			GraphLayer graphLayer = m_paintGraphLayerList.getValues().get(i); 
			// Zp[^ƃ[[̓
			if (graphLayer.getLayerNo()==0) {
				graphLayer.setSyncRuler(true);
			} else {
				graphLayer.setSyncRuler(false);
			}
		}	
		m_paintGraphLayerList.syncRuler();
		// TuC̘g
		setShowSubLayerRect(false);	
	}

	/**
	 * VOi{bNXԂ܂B
	 * 
	 * @since 2.80
	 * @return VOi{bNX
	 */
	public CoreFramework getSignalBox() {
		return m_signalBox;
	}

	/**
	 * VOi{bNXݒ肵܂B
	 * 
	 * @since 2.80
	 * @param p_signalBox VOi{bNX
	 */
	public void setSignalBox(CoreFramework p_signalBox) {
		m_signalBox = p_signalBox;
		clearLayer();
	}

	/**
	 * Cǉ܂B
	 * 
	 * @since 2.80
	 * @param p_name C
	 * @param p_layerNo CԍB
	 *         ̃eNjJwW𓯂Cɏd˂ĕ\ꍇ͓lZbg܂B
	 *         ꃌCԍ̃C͍őlAŏl̓Ƃ܂B
	 *         XgœCԍꍇɏdˍ킹ĕ`悳܂B
	 *         GraphLayerListœCԍAĂKv܂B
	 * @param p_divCount ڐʂ̂悻ŕ`悷邩w肵܂B
	 * @return ǉC̃CX^X
	 * @throws GraphException C̐Ɏsꍇ
	 */
	public GraphLayer addLayer(String p_name, int p_layerNo, int p_divCount) throws GraphException {
		return m_graphLayerList.add(p_name, m_signalBox.getViewList().get(p_name), p_layerNo, p_divCount, m_titleBarTopOffset, m_indexBottomOffset);
	}

	/**
	 * w肵CCԂ܂B
	 * 
	 * @since 2.80
	 * @param p_name C
	 * @return C
	 */
	public GraphLayer getLayer(String p_name) {
		for (GraphLayer layer: m_graphLayerList.getValues()) {
			if (layer.getName().equals(p_name)) return layer;
		}
		return null;
	}
	
	/**
	 * C܂B
	 * 
	 * @since 2.80
	 */
	public void clearLayer() {
		m_graphLayerList = new GraphLayerList(this);
		m_paintGraphLayerList = new GraphLayerList(this);
	}
	
	/**
	 * hbvꏊɑ΂ǉCԍԂ܂B
	 * 
	 * @since 2.80
	 * @param p_dropPoint hbvW
	 * @return hbvꏊɑ΂ǉCԍB
	 */
	public int getDropLayerNo(Point p_dropPoint) {
		if (m_paintGraphLayerList.getValues().size()<=0) return 0;
		int mainLayerBorder = (int)(getHeight() * m_mainLayerHeightRatio / 100);
		if (p_dropPoint.y <= mainLayerBorder) {
			return 0;
		}
		return m_paintGraphLayerList.getMaxLayerNo() + 1;
	}
	
	/**
	 * OtC̃Xgi`pjԂ܂B
	 * 
	 * @since 2.80
	 * @return OtC̃Xgi`pj
	 */
	protected GraphLayerList getPaintGraphLayerList() {
		return m_paintGraphLayerList;
	}

	/**
	 * Ot\ĂȂԂ̏ꍇtrueԂ܂B
	 * 
	 * @since 2.80
	 * @return Ot\ĂȂԂ̏ꍇtrue
	 */
	public boolean isEmpty() {
		return m_empty;
	}

	/**
	 * Ot\ĂȂԂ̎ɕ\郁bZ[WԂ܂B
	 * 
	 * @since 2.80
	 * @return Ot\ĂȂԂ̎ɕ\郁bZ[W
	 */
	public String getEmptyMessage() {
		return m_emptyMessage;
	}

	/**
	 * Ot\ĂȂԂ̎ɕ\郁bZ[Wݒ肵܂B
	 * 
	 * @since 2.80
	 * @param p_emptyMessage Ot\ĂȂԂ̎ɕ\郁bZ[W
	 */
	public void setEmptyMessage(String p_emptyMessage) {
		m_emptyMessage = p_emptyMessage;
	}

	/**
	 * Ot\ĂȂԂ̎ɕ\郁bZ[W̕FԂ܂B
	 *  
	 * @since 2.80
	 * @return Ot\ĂȂԂ̎ɕ\郁bZ[W̕F
	 */
	public Color getEmptyMessageForeColor() {
		return m_emptyMessageForeColor;
	}

	/**
	 * Ot\ĂȂԂ̎ɕ\郁bZ[W̕Fݒ肵܂B
	 *  
	 * @since 2.80
	 * @param p_emptyMessageForeColor Ot\ĂȂԂ̎ɕ\郁bZ[W̕F
	 */
	public void setEmptyMessageForeColor(Color p_emptyMessageForeColor) {
		m_emptyMessageForeColor = p_emptyMessageForeColor;
	}

	/**
	 * Ot\ĂȂԂ̎ɕ\郁bZ[W̃tHgԂ܂B
	 *  
	 * @since 2.80
	 * @return Ot\ĂȂԂ̎ɕ\郁bZ[W̃tHg
	 */
	public Font getEmptyMessageFont() {
		return m_emptyMessageFont;
	}

	/**
	 * Ot\ĂȂԂ̎ɕ\郁bZ[W̃tHgݒ肵܂B
	 *  
	 * @since 2.80
	 * @param p_emptyMessageFont Ot\ĂȂԂ̎ɕ\郁bZ[W̃tHg
	 */
	public void setEmptyMessageFont(Font p_emptyMessageFont) {
		m_emptyMessageFont = p_emptyMessageFont;
	}

}
