/**
 * Copyright (C) 2013 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.framework;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

import jp.robotbrain.common.StringComparator;

/**
 * qXgJf[^ǗNX
 * 
 * @since 2.80
 * @author Copyright (C) 2013 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class HistoricalDataList {
	
	/**
	 * qXgJf[^̃|C^
	 * 
	 * @since 2.80
	 */
	private Pointer m_pointer;

	/**
	 * qXgJf[^̃t@C̃Xg
	 * 
	 * @since 2.80
	 */
	private ArrayList<String> m_tradingDateList;

	/**
	 * qXgJf[^̃t@C̃Xg̃LbVBς݂̃f[^ێB
	 * 
	 * @since 2.80
	 */
	private static HashMap<String,HistoricalDataList> m_cacheTable = new HashMap<String,HistoricalDataList>();
	
	/**
	 * HistoricalDataList𐶐܂B
	 * 
	 * @since 2.80
	 */
	private HistoricalDataList() {
	}
	
	/**
	 * HistoricalDataList𐶐܂B
	 * 
	 * @since 2.80
	 * @param p_historicalDataFolderPath qXgJf[^ĂtH_̃pX
	 * @throws HistoricalDataException qXgJf[^̃XgAbvɎsꍇ
	 */
	@SuppressWarnings("unchecked")
	public static synchronized HistoricalDataList create(String p_historicalDataFolderPath) throws HistoricalDataException {
		HistoricalDataList returnValue = null;
		// ɏς̃f[^̓LbV擾ĕԂ
		HistoricalDataList cache = m_cacheTable.get(p_historicalDataFolderPath.toUpperCase());
		if (cache!=null) {
			returnValue = new HistoricalDataList();
			returnValue.m_pointer = new Pointer();
			returnValue.m_tradingDateList = (ArrayList<String>)cache.m_tradingDateList.clone();
			return returnValue;
		}
		// VKɃt@CXgAbv
		returnValue = new HistoricalDataList();
		returnValue.m_pointer = new Pointer();
		returnValue.m_tradingDateList = new ArrayList<String>();
		if (p_historicalDataFolderPath==null || p_historicalDataFolderPath.equals("")) {
			String msg = "HistoricalData Path Error: " + p_historicalDataFolderPath;
			throw new HistoricalDataException(msg);
		}
		File f = new File(p_historicalDataFolderPath);
		File[] flist = f.listFiles();
		if (flist==null) {
			String msg = "HistoricalData Listing Error: " + p_historicalDataFolderPath;
			throw new HistoricalDataException(msg);
		}
		// t@CŃ\[g
		for (int i=0;i<flist.length;i++) {
			returnValue.m_tradingDateList.add(flist[i].getName());
		}
		Collections.sort(returnValue.m_tradingDateList, new StringComparator(false));
		m_cacheTable.put(p_historicalDataFolderPath.toUpperCase(), returnValue);
		return returnValue;
	}

	/**
	 * w肵kqXgJf[^t@C̃XgԂ܂B
	 * 
	 * @since 2.80
	 * @param p_tradingDate iyyyyMMdd`j
	 * @param p_pastDays 牽ߋk邩w肵܂
	 * @return qXgJf[^t@C̃Xg
	 * @throws HistoricalDataException qXgJf[^Ȃꍇ
	 */
	public ArrayList<String> getPastList(String p_tradingDate, int p_pastDays) throws HistoricalDataException {
		ArrayList<String> returnValue = new ArrayList<String>();
		if (m_tradingDateList.size()<=0) return returnValue;
		// w肳ꂽ̃qXgJf[^݂邩mF
		int tradingDatePoint = m_tradingDateList.indexOf(p_tradingDate);
		if (tradingDatePoint<0) {
			// qXgJf[^Ȃꍇ͎VtmF
			String lastDate = m_tradingDateList.get(m_tradingDateList.size()-1);
			if (Integer.parseInt(lastDate)<Integer.parseInt(p_tradingDate)) {
				tradingDatePoint = m_tradingDateList.size();
			} else {
				String msg = "NotFound HistoricalData lastDate:" + lastDate + " tradingDate:" + p_tradingDate;
				throw new HistoricalDataException(msg);
			}
		}
		// ̎܂܂Ȃt@CXg𐶐
		// p_pastDays=3 tradingDatePoint=5 ̏ꍇ
		//  0  1  2  3  4  5  6  7  8  9 -> size=10
		//                 *tradingDatePoint
		//        *loop p_pastHistoricalDataCount=3 
		//           *loop p_pastHistoricalDataCount=2
		//              *loop p_pastHistoricalDataCount=1
		for (int i=p_pastDays;i>=1;i--) {
			if (tradingDatePoint-i>=0) {
				String pastDate = m_tradingDateList.get(tradingDatePoint-i);
				returnValue.add(pastDate);
			}
		}
		return returnValue;
	}

	/**
	 * Pڂ̃qXgJf[^Ɉړăt@CԂ܂B
	 * 
	 * @since 2.80
	 * @return qXgJf[^̃t@CB擾łȂꍇ͋󕶎""Ԃ܂B
	 */
	public String moveFirst() {
		if (m_tradingDateList.size()<=0) return "";
		m_pointer.moveFirst();
		return m_tradingDateList.get(0);
	}

	/**
	 * Ō̃qXgJf[^Ɉړăt@CԂ܂B
	 * 
	 * @since 2.80
	 * @return qXgJf[^̃t@CB擾łȂꍇ͋󕶎""Ԃ܂B
	 */
	public String moveLast() {
		if (m_tradingDateList.size()<1) return "";
		int lastPointer = m_tradingDateList.size() - 1;
		m_pointer.move(lastPointer);
		return m_tradingDateList.get(lastPointer);
	}
	
	/**
	 * ̃qXgJf[^Ɉړăt@CԂ܂B
	 * 
	 * @since 2.80
	 * @return qXgJf[^̃t@CB擾łȂꍇ͋󕶎""Ԃ܂B
	 */
	public String moveNext() {
		if (m_tradingDateList.size()<=m_pointer.getValue()+1) return "";
		m_pointer.moveNext();
		return m_tradingDateList.get(m_pointer.getValue());
	}

	/**
	 * ÕqXgJf[^Ɉړăt@CԂ܂B
	 * 
	 * @since 2.80
	 * @return qXgJf[^̃t@CB擾łȂꍇ͋󕶎""Ԃ܂B
	 */
	public String movePrev() {
		if (0 > m_pointer.getValue()-1) return "";
		m_pointer.movePrev();
		return m_tradingDateList.get(m_pointer.getValue());
	}

	/**
	 * w肵߂qXgJf[^Ɉړăt@CԂ܂B
	 * 
	 * @since 2.80
	 * @param p_prevDays ߂
	 * @return qXgJf[^̃t@CB擾łȂꍇ͋󕶎""Ԃ܂B
	 */
	public String movePrev(int p_prevDays) {
		String returnValue = "";
		for (int i=0;i<p_prevDays;i++) {
			returnValue = movePrev();
			if (returnValue.equals("")) {
				return moveFirst();
			}
		}
		return returnValue;
	}
	
	/**
	 * w肵t̃qXgJf[^Ɉړăt@CԂ܂B
	 * 
	 * @since 2.80
	 * @param p_tradingDate ړ̓tiyyyyMMdd`j
	 * @return qXgJf[^̃t@CB擾łȂꍇ͋󕶎""Ԃ܂B
	 */
	public String move(String p_tradingDate) {
		int i = m_tradingDateList.indexOf(p_tradingDate);
		if (i<0) return "";
		m_pointer.move(i);
		return m_tradingDateList.get(m_pointer.getValue());
	}
	
	/**
	 * qXgJf[^̓tXgԂ܂B
	 * 
	 * @since 2.80
	 * @return qXgJf[^̓tXg
	 */
	public ArrayList<String> getValues() {
		return m_tradingDateList;
	}
	
}
