/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexPoint;

/**
 * ϒlC
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class CandleStickAvgLine extends IndexLine {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * ϒl̒̏Il̔䗦
	 * 
	 * @since 1.00
	 */
	private final int m_closeRatio;
	
	/**
	 * CandleStickAvgLine𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_closeRatio ϒl̒̏Il̔䗦B
	 * l{l{(Il~closeRatio)(2+closeRatio)ŕς߂܂B
	 */
	public CandleStickAvgLine(int p_closeRatio) {
		super(NmViewType.INDEXLINE);
		m_closeRatio = p_closeRatio;
	}

	/**
	 * lAlAIl̕ϒlCɒǉ܂B
	 * 
	 * @since 1.00
	 * @param p_src [\N
	 */
	public void addPoint(CandleStick p_src) {
		if (p_src==null) return;
		double avg = (p_src.getHigh() + p_src.getLow() + p_src.getClose() * m_closeRatio) / 
			(2+m_closeRatio);
		add(new IndexPoint(p_src.getTag(), avg));
	}
	
}
