/**
 * Copyright (C) 2010 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.common;

/**
 * t@CtH_̈ʒuipXURLj
 * 
 * @since 2.33
 * @author Copyright (C) 2010 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class Location {

	/**
	 * Windows`̃pX
	 * 
	 * @since 2.33
	 */
	private String m_windowsStyle;
	
	/**
	 * Unix`̃pX
	 * 
	 * @since 2.33
	 */
	private String m_unixStyle;

	/**
	 * URL
	 * 
	 * @since 2.33
	 */
	private String m_urlStyle;

	/**
	 * ZbVID
	 * 
	 * @since 2.60
	 */
	private String m_sessionId;
	
	/**
	 * pX̋؂蕶
	 * 
	 * @since 2.33
	 */
	public static final String FSP = System.getProperty("file.separator");
	
	/**
	 * Path𐶐܂B
	 * 
	 * @since 2.33
	 */
	public Location() {
	}
	
	/**
	 * Path𐶐܂B
	 * 
	 * @since 2.33
	 * @param p_path t@CtH_̃pX
	 */
	public Location(String p_path) {
		if (FSP.equals("\\")) {
			m_windowsStyle = p_path;
		} else if (FSP.equals("/")) {
			m_unixStyle = p_path;
		}
	}

	/**
	 * t@CtH_̈ʒu𕶎ŕԂ܂B
	 * 
	 * @since 2.33
	 * @return t@CtH_̈ʒu
	 */
	@Override
	public String toString() {
		if (FSP.equals("\\")) {
			return m_windowsStyle;
		} else if (FSP.equals("/")) {
			return m_unixStyle;
		} else {
			return null;
		}
	}

	/**
	 * Windows`̃pXԂ܂B
	 * 
	 * @since 2.33
	 * @return Windows`̃pX
	 */
	public String getWindowsStyle() {
		return m_windowsStyle;
	}

	/**
	 * Windows`̃pXݒ肵܂B
	 * 
	 * @since 2.33
	 * @param p_windowsStyle Windows`̃pX
	 */
	public void setWindowsStyle(String p_windowsStyle) {
		m_windowsStyle = p_windowsStyle;
	}

	/**
	 * Unix`̃pXԂ܂B
	 * 
	 * @since 2.33
	 * @return Unix`̃pX
	 */
	public String getUnixStyle() {
		return m_unixStyle;
	}

	/**
	 * Unix`̃pXݒ肵܂B
	 * 
	 * @since 2.33
	 * @param p_unixStyle Unix`̃pX
	 */
	public void setUnixStyle(String p_unixStyle) {
		m_unixStyle = p_unixStyle;
	}

	/**
	 * URLԂ܂B
	 * 
	 * @since 2.33
	 * @return URL
	 */
	public String getUrlStyle() {
		return m_urlStyle;
	}

	/**
	 * URLݒ肵܂B
	 * 
	 * @since 2.33
	 * @param p_url URL
	 */
	public void setUrlStyle(String p_url) {
		m_urlStyle = p_url;
	}

	/**
	 * ZbVIDԂ܂B
	 * 
	 * @since 2.60
	 * @return ZbVID
	 */
	public String getSessionId() {
		return m_sessionId;
	}

	/**
	 * ZbVIDݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_sessionId ZbVID
	 */
	public void setSessionId(String p_sessionId) {
		m_sessionId = p_sessionId;
	}
	
}
