/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.log.LogLevel;
import org.apache.hadoop.util.ReflectionUtils;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.MultiException;

public class HttpServer
implements FilterContainer {
    public static final Log LOG = LogFactory.getLog(HttpServer.class);
    static final String FILTER_INITIALIZER_PROPERTY = "hadoop.http.filter.initializers";
    protected final Server webServer;
    protected final Connector listener;
    protected final WebAppContext webAppContext;
    protected final boolean findPort;
    protected final Map<Context, Boolean> defaultContexts = new HashMap<Context, Boolean>();
    protected final List<String> filterNames = new ArrayList<String>();
    private static final int MAX_RETRIES = 10;

    public HttpServer(String name, String bindAddress, int port, boolean findPort) throws IOException {
        this(name, bindAddress, port, findPort, new Configuration());
    }

    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf) throws IOException {
        this.webServer = new Server();
        this.findPort = findPort;
        this.listener = this.createBaseListener(conf);
        this.listener.setHost(bindAddress);
        this.listener.setPort(port);
        this.webServer.addConnector(this.listener);
        this.webServer.setThreadPool((ThreadPool)new QueuedThreadPool());
        String appDir = this.getWebAppsPath();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this.webServer.setHandler((Handler)contexts);
        this.webAppContext = new WebAppContext();
        this.webAppContext.setContextPath("/");
        this.webAppContext.setWar(appDir + "/" + name);
        this.webServer.addHandler((Handler)this.webAppContext);
        this.addDefaultApps(contexts, appDir);
        FilterInitializer[] initializers = HttpServer.getFilterInitializers(conf);
        if (initializers != null) {
            for (FilterInitializer c : initializers) {
                c.initFilter(this);
            }
        }
        this.addDefaultServlets();
    }

    protected Connector createBaseListener(Configuration conf) throws IOException {
        SelectChannelConnector ret = new SelectChannelConnector();
        ret.setLowResourceMaxIdleTime(10000);
        ret.setAcceptQueueSize(128);
        ret.setResolveNames(false);
        ret.setUseDirectBuffers(false);
        return ret;
    }

    private static FilterInitializer[] getFilterInitializers(Configuration conf) {
        if (conf == null) {
            return null;
        }
        Class<?>[] classes = conf.getClasses(FILTER_INITIALIZER_PROPERTY, new Class[0]);
        if (classes == null) {
            return null;
        }
        FilterInitializer[] initializers = new FilterInitializer[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            initializers[i] = (FilterInitializer)ReflectionUtils.newInstance(classes[i], conf);
        }
        return initializers;
    }

    protected void addDefaultApps(ContextHandlerCollection parent, String appDir) throws IOException {
        String logDir = System.getProperty("hadoop.log.dir");
        if (logDir != null) {
            Context logContext = new Context((HandlerContainer)parent, "/logs");
            logContext.setResourceBase(logDir);
            logContext.addServlet(DefaultServlet.class, "/");
            this.defaultContexts.put(logContext, true);
        }
        Context staticContext = new Context((HandlerContainer)parent, "/static");
        staticContext.setResourceBase(appDir + "/static");
        staticContext.addServlet(DefaultServlet.class, "/*");
        this.defaultContexts.put(staticContext, true);
    }

    protected void addDefaultServlets() {
        this.addServlet("stacks", "/stacks", StackServlet.class);
        this.addServlet("logLevel", "/logLevel", LogLevel.Servlet.class);
    }

    public void addContext(Context ctxt, boolean isFiltered) throws IOException {
        this.webServer.addHandler((Handler)ctxt);
        this.defaultContexts.put(ctxt, isFiltered);
    }

    protected void addContext(String pathSpec, String dir, boolean isFiltered) throws IOException {
        if (0 == this.webServer.getHandlers().length) {
            throw new RuntimeException("Couldn't find handler");
        }
        WebAppContext webAppCtx = new WebAppContext();
        webAppCtx.setContextPath(pathSpec);
        webAppCtx.setWar(dir);
        this.addContext((Context)webAppCtx, true);
    }

    public void setAttribute(String name, Object value) {
        this.webAppContext.setAttribute(name, value);
    }

    public void addServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.addInternalServlet(name, pathSpec, clazz);
        this.addFilterPathMapping(pathSpec, (Context)this.webAppContext);
    }

    @Deprecated
    public void addInternalServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        ServletHolder holder = new ServletHolder(clazz);
        if (name != null) {
            holder.setName(name);
        }
        this.webAppContext.addServlet(holder, pathSpec);
    }

    @Override
    public void addFilter(String name, String classname, Map<String, String> parameters) {
        String[] USER_FACING_URLS = new String[]{"*.html", "*.jsp"};
        this.defineFilter((Context)this.webAppContext, name, classname, parameters, USER_FACING_URLS);
        String[] ALL_URLS = new String[]{"/*"};
        for (Map.Entry<Context, Boolean> e : this.defaultContexts.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            Context ctx = e.getKey();
            this.defineFilter(ctx, name, classname, parameters, ALL_URLS);
            LOG.info((Object)("Added filter " + name + " (class=" + classname + ") to context " + ctx.getDisplayName()));
        }
        this.filterNames.add(name);
    }

    @Override
    public void addGlobalFilter(String name, String classname, Map<String, String> parameters) {
        String[] ALL_URLS = new String[]{"/*"};
        this.defineFilter((Context)this.webAppContext, name, classname, parameters, ALL_URLS);
        for (Context ctx : this.defaultContexts.keySet()) {
            this.defineFilter(ctx, name, classname, parameters, ALL_URLS);
        }
        LOG.info((Object)("Added global filter" + name + " (class=" + classname + ")"));
    }

    protected void defineFilter(Context ctx, String name, String classname, Map<String, String> parameters, String[] urls) {
        FilterHolder holder = new FilterHolder();
        holder.setName(name);
        holder.setClassName(classname);
        holder.setInitParameters(parameters);
        FilterMapping fmap = new FilterMapping();
        fmap.setPathSpecs(urls);
        fmap.setDispatches(15);
        fmap.setFilterName(name);
        ServletHandler handler = ctx.getServletHandler();
        handler.addFilter(holder, fmap);
    }

    protected void addFilterPathMapping(String pathSpec, Context webAppCtx) {
        ServletHandler handler = webAppCtx.getServletHandler();
        for (String name : this.filterNames) {
            FilterMapping fmap = new FilterMapping();
            fmap.setPathSpec(pathSpec);
            fmap.setFilterName(name);
            fmap.setDispatches(15);
            handler.addFilterMapping(fmap);
        }
    }

    public Object getAttribute(String name) {
        return this.webAppContext.getAttribute(name);
    }

    protected String getWebAppsPath() throws IOException {
        URL url = this.getClass().getClassLoader().getResource("webapps");
        if (url == null) {
            throw new IOException("webapps not found in CLASSPATH");
        }
        return url.toString();
    }

    public int getPort() {
        return this.webServer.getConnectors()[0].getLocalPort();
    }

    public void setThreads(int min, int max) {
        QueuedThreadPool pool = (QueuedThreadPool)this.webServer.getThreadPool();
        pool.setMinThreads(min);
        pool.setMaxThreads(max);
    }

    @Deprecated
    public void addSslListener(InetSocketAddress addr, String keystore, String storPass, String keyPass) throws IOException {
        if (this.webServer.isStarted()) {
            throw new IOException("Failed to add ssl listener");
        }
        SslSocketConnector sslListener = new SslSocketConnector();
        sslListener.setHost(addr.getHostName());
        sslListener.setPort(addr.getPort());
        sslListener.setKeystore(keystore);
        sslListener.setPassword(storPass);
        sslListener.setKeyPassword(keyPass);
        this.webServer.addConnector((Connector)sslListener);
    }

    public void addSslListener(InetSocketAddress addr, Configuration sslConf, boolean needClientAuth) throws IOException {
        if (this.webServer.isStarted()) {
            throw new IOException("Failed to add ssl listener");
        }
        if (needClientAuth) {
            System.setProperty("javax.net.ssl.trustStore", sslConf.get("ssl.server.truststore.location", ""));
            System.setProperty("javax.net.ssl.trustStorePassword", sslConf.get("ssl.server.truststore.password", ""));
            System.setProperty("javax.net.ssl.trustStoreType", sslConf.get("ssl.server.truststore.type", "jks"));
        }
        SslSocketConnector sslListener = new SslSocketConnector();
        sslListener.setHost(addr.getHostName());
        sslListener.setPort(addr.getPort());
        sslListener.setKeystore(sslConf.get("ssl.server.keystore.location"));
        sslListener.setPassword(sslConf.get("ssl.server.keystore.password", ""));
        sslListener.setKeyPassword(sslConf.get("ssl.server.keystore.keypassword", ""));
        sslListener.setKeystoreType(sslConf.get("ssl.server.keystore.type", "jks"));
        sslListener.setNeedClientAuth(needClientAuth);
        this.webServer.addConnector((Connector)sslListener);
    }

    public void start() throws IOException {
        try {
            int port = 0;
            int oriPort = this.listener.getPort();
            while (true) {
                try {
                    port = this.webServer.getConnectors()[0].getLocalPort();
                    LOG.info((Object)("Port returned by webServer.getConnectors()[0].getLocalPort() before open() is " + port + ". Opening the listener on " + oriPort));
                    this.listener.open();
                    port = this.listener.getLocalPort();
                    LOG.info((Object)("listener.getLocalPort() returned " + this.listener.getLocalPort() + " webServer.getConnectors()[0].getLocalPort() returned " + this.webServer.getConnectors()[0].getLocalPort()));
                    if (port < 0) {
                        Thread.sleep(100L);
                        int numRetries = 1;
                        while (port < 0) {
                            LOG.warn((Object)("listener.getLocalPort returned " + port));
                            if (numRetries++ > 10) {
                                throw new Exception(" listener.getLocalPort is returning less than 0 even after " + numRetries + " resets");
                            }
                            for (int i = 0; i < 2; ++i) {
                                LOG.info((Object)"Retrying listener.getLocalPort()");
                                port = this.listener.getLocalPort();
                                if (port > 0) break;
                                Thread.sleep(200L);
                            }
                            if (port > 0) break;
                            LOG.info((Object)"Bouncing the listener");
                            this.listener.close();
                            Thread.sleep(1000L);
                            this.listener.setPort(oriPort == 0 ? 0 : ++oriPort);
                            this.listener.open();
                            Thread.sleep(100L);
                            port = this.listener.getLocalPort();
                        }
                    }
                    LOG.info((Object)("Jetty bound to port " + port));
                    this.webServer.start();
                    break;
                }
                catch (IOException ex) {
                    if (ex instanceof BindException) {
                        if (!this.findPort) {
                            throw (BindException)ex;
                        }
                    }
                    LOG.info((Object)"HttpServer.start() threw a non Bind IOException");
                    throw ex;
                }
                catch (MultiException ex) {
                    LOG.info((Object)"HttpServer.start() threw a MultiException");
                    throw ex;
                }
                this.listener.setPort(++oriPort);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Problem starting http server", e);
        }
    }

    public void stop() throws Exception {
        this.listener.close();
        this.webServer.stop();
    }

    public void join() throws InterruptedException {
        this.webServer.join();
    }

    public static class StackServlet
    extends HttpServlet {
        private static final long serialVersionUID = -6284183679759467039L;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter out = new PrintWriter((OutputStream)response.getOutputStream());
            ReflectionUtils.printThreadInfo(out, "");
            out.close();
            ReflectionUtils.logThreadInfo(LOG, "jsp requested", 1L);
        }
    }
}

