/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.XPathContainer;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSecTest
extends TestCase {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$test$signature$XmlSecTest == null ? (class$org$apache$xml$security$test$signature$XmlSecTest = XmlSecTest.class$("org.apache.xml.security.test.signature.XmlSecTest")) : class$org$apache$xml$security$test$signature$XmlSecTest).getName());
    static /* synthetic */ Class class$org$apache$xml$security$test$signature$XmlSecTest;

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$signature$XmlSecTest == null ? (class$org$apache$xml$security$test$signature$XmlSecTest = XmlSecTest.class$("org.apache.xml.security.test.signature.XmlSecTest")) : class$org$apache$xml$security$test$signature$XmlSecTest);
    }

    public void testCheckXmlSignatureSoftwareStack() throws Exception {
        this.checkXmlSignatureSoftwareStack(false);
    }

    public void testCheckXmlSignatureSoftwareStackWithCert() throws Exception {
        this.checkXmlSignatureSoftwareStack(true);
    }

    private void checkXmlSignatureSoftwareStack(boolean bl) throws Exception {
        KeyStore keyStore;
        Object object;
        Object object2;
        Init.init();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElementNS("urn:namespace", "tns:document");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tns", "urn:namespace");
        document.appendChild(element);
        Element element2 = document.createElementNS("urn:childnamespace", "t:child");
        element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:t", "urn:childnamespace");
        element2.appendChild(document.createTextNode("hello world"));
        element.appendChild(element2);
        PrivateKey privateKey = null;
        PublicKey publicKey = null;
        X509Certificate x509Certificate = null;
        if (bl) {
            object2 = System.getProperty("file.separator");
            object = new FileInputStream(System.getProperty("basedir") + (String)object2 + "data" + (String)object2 + "test.jks");
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load((InputStream)object, "changeit".toCharArray());
            x509Certificate = (X509Certificate)keyStore.getCertificate("mullan");
            publicKey = x509Certificate.getPublicKey();
            privateKey = (PrivateKey)keyStore.getKey("mullan", "changeit".toCharArray());
        } else {
            object2 = KeyPairGenerator.getInstance("DSA").generateKeyPair();
            publicKey = ((KeyPair)object2).getPublic();
            privateKey = ((KeyPair)object2).getPrivate();
        }
        object2 = new XMLSignature(document, "", "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        object = object2.getElement();
        element.appendChild((Node)object);
        keyStore = new Transforms(document);
        XPathContainer xPathContainer = new XPathContainer(document);
        xPathContainer.setXPathNamespaceContext("ds", "http://www.w3.org/2000/09/xmldsig#");
        xPathContainer.setXPath("not(ancestor-or-self::ds:Signature)");
        keyStore.addTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", xPathContainer.getElementPlusReturns());
        keyStore.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        object2.addDocument("", (Transforms)keyStore, "http://www.w3.org/2000/09/xmldsig#sha1");
        if (bl) {
            object2.addKeyInfo(x509Certificate);
        } else {
            object2.addKeyInfo(publicKey);
        }
        Element element3 = document.createElementNS(null, "nsElement");
        element3.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        object2.sign((Key)privateKey);
        NodeList nodeList = XPathAPI.selectNodeList((Node)document, (String)"//ds:Signature", (Node)element3);
        object = (Element)nodeList.item(0);
        XMLSignature xMLSignature = new XMLSignature((Element)object, "");
        boolean bl2 = xMLSignature.checkSignatureValue((Key)publicKey);
        XmlSecTest.assertTrue((boolean)bl2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

