/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.utils.resolver;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.utils.URI;
import org.w3c.dom.Attr;

public class OfflineResolver
extends ResourceResolverSpi {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$test$utils$resolver$OfflineResolver == null ? (class$org$apache$xml$security$test$utils$resolver$OfflineResolver = OfflineResolver.class$("org.apache.xml.security.test.utils.resolver.OfflineResolver")) : class$org$apache$xml$security$test$utils$resolver$OfflineResolver).getName());
    static Map _uriMap = null;
    static Map _mimeMap = null;
    static /* synthetic */ Class class$org$apache$xml$security$test$utils$resolver$OfflineResolver;

    public XMLSignatureInput engineResolve(Attr attr, String string) throws ResourceResolverException {
        try {
            String string2 = attr.getNodeValue();
            if (_uriMap.containsKey(string2)) {
                String string3 = (String)_uriMap.get(string2);
                log.debug((Object)("Mapped " + string2 + " to " + string3));
                FileInputStream fileInputStream = new FileInputStream(string3);
                log.debug((Object)("Available bytes = " + ((InputStream)fileInputStream).available()));
                XMLSignatureInput xMLSignatureInput = new XMLSignatureInput((InputStream)fileInputStream);
                xMLSignatureInput.setSourceURI(string2);
                xMLSignatureInput.setMIMEType((String)_mimeMap.get(string2));
                return xMLSignatureInput;
            }
            Object[] objectArray = new Object[]{"The URI " + string2 + " is not configured for offline work"};
            throw new ResourceResolverException("generic.EmptyMessage", objectArray, attr, string);
        }
        catch (IOException iOException) {
            throw new ResourceResolverException("generic.EmptyMessage", (Exception)iOException, attr, string);
        }
    }

    public boolean engineCanResolve(Attr attr, String string) {
        String string2 = attr.getNodeValue();
        if (string2.equals("") || string2.startsWith("#")) {
            return false;
        }
        try {
            URI uRI = new URI(new URI(string), attr.getNodeValue());
            if (uRI.getScheme().equals("http")) {
                log.debug((Object)("I state that I can resolve " + uRI.toString()));
                return true;
            }
            log.debug((Object)("I state that I can't resolve " + uRI.toString()));
        }
        catch (URI.MalformedURIException malformedURIException) {
            // empty catch block
        }
        return false;
    }

    private static void register(String string, String string2, String string3) {
        _uriMap.put(string, string2);
        _mimeMap.put(string, string3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Init.init();
        _uriMap = new HashMap();
        _mimeMap = new HashMap();
        String string = System.getProperty("basedir");
        string = string == null ? "/" : string + "/";
        OfflineResolver.register("http://www.w3.org/TR/xml-stylesheet", string + "data/org/w3c/www/TR/xml-stylesheet.html", "text/html");
        OfflineResolver.register("http://www.w3.org/TR/2000/REC-xml-20001006", string + "data/org/w3c/www/TR/2000/REC-xml-20001006", "text/xml");
        OfflineResolver.register("http://www.nue.et-inf.uni-siegen.de/index.html", string + "data/org/apache/xml/security/temp/nuehomepage", "text/html");
        OfflineResolver.register("http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/id2.xml", string + "data/org/apache/xml/security/temp/id2.xml", "text/xml");
        OfflineResolver.register("http://xmldsig.pothole.com/xml-stylesheet.txt", string + "data/com/pothole/xmldsig/xml-stylesheet.txt", "text/xml");
        OfflineResolver.register("http://www.w3.org/Signature/2002/04/xml-stylesheet.b64", string + "data/ie/baltimore/merlin-examples/merlin-xmldsig-twenty-three/xml-stylesheet.b64", "text/plain");
    }
}

