#-*- coding: utf-8; -*-

# To change this template, choose Tools | Templates
# and open the template in the editor.

module Mastermind
  class Game

    def initialize(interactor, random_generator)
      @interactor = interactor
      @random_generator = random_generator
    end

    def play
      code = Code.generate_using(@random_generator)
      turns = 0
      while turns < 10 && (not won?)
        turns += 1
        take_turn(turns, code)
      end
      @interactor.writeline('You lose after 10 turns.') if turns == 10  && !won? 
      @interactor.writeline("You won in #{turns} turn#{turns > 1 ? 's' : ''}.") if won? 
    end

    def take_turn(turn_number, secret_code)
      @interactor.write("Enter guess \##{turn_number}: ")
      guess_string = @interactor.readline
      guess = Code.from_string(guess_string)
      @score = secret_code.mark(guess)
      @interactor.writeline @score.to_s 
    end

    def won?
      (not @score.nil?) && @score.win?
    end

  end

end
