<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:saxon="http://saxon.sf.net/" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:iso="http://purl.oclc.org/dsdl/schematron" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:ixt="http://www.xbrl.org/2008/inlineXBRL/transformation" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
<xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


<!--PROLOG-->
<xsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl" method="xml" omit-xml-declaration="no" standalone="yes" indent="yes"/>

   <!--XSD TYPES FOR XSLT2-->


<!--KEYS AND FUNCTIONS-->


<!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding" select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
<!--This mode can be used to generate prefixed XPath for humans-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
<!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
<xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
<xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters--><xsl:template match="text()" priority="-1" mode="ixbrl-schematron-main"/>

   <!--SCHEMA SETUP-->
<xsl:template match="/" mode="ixbrl-schematron-main">
      <svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl" title="" schemaVersion="">
         <xsl:comment>
            <xsl:value-of select="$archiveDirParameter"/>   
		 <xsl:value-of select="$archiveNameParameter"/>  
		 <xsl:value-of select="$fileNameParameter"/>  
		 <xsl:value-of select="$fileDirParameter"/>
         </xsl:comment>
         <svrl:ns-prefix-in-attribute-values uri="http://www.xbrl.org/2008/inlineXBRL" prefix="ix"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.xbrl.org/2008/inlineXBRL/transformation" prefix="ixt"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.xbrl.org/2003/instance" prefix="xbrli"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/1999/xhtml" prefix="xhtml"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">unique-footnote-id</xsl:attribute>
            <xsl:attribute name="name">unique-footnote-id</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M7"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">unique-id</xsl:attribute>
            <xsl:attribute name="name">unique-id</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M8"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">tuple-ref</xsl:attribute>
            <xsl:attribute name="name">tuple-ref</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M9"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">footnote-refs</xsl:attribute>
            <xsl:attribute name="name">footnote-refs</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M10"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">context-ref</xsl:attribute>
            <xsl:attribute name="name">context-ref</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M11"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">format-name</xsl:attribute>
            <xsl:attribute name="name">format-name</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M12"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">formatted-value</xsl:attribute>
            <xsl:attribute name="name">formatted-value</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M13"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">unit-ref</xsl:attribute>
            <xsl:attribute name="name">unit-ref</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M14"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">format-absent</xsl:attribute>
            <xsl:attribute name="name">format-absent</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M15"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">header-count</xsl:attribute>
            <xsl:attribute name="name">header-count</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M16"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">references-for-each-target</xsl:attribute>
            <xsl:attribute name="name">references-for-each-target</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M17"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">resources-count</xsl:attribute>
            <xsl:attribute name="name">resources-count</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M18"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">unique-context-id</xsl:attribute>
            <xsl:attribute name="name">unique-context-id</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M19"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">unique-unit-id</xsl:attribute>
            <xsl:attribute name="name">unique-unit-id</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M20"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">order-attribute</xsl:attribute>
            <xsl:attribute name="name">order-attribute</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M21"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">unique-tuple-id</xsl:attribute>
            <xsl:attribute name="name">unique-tuple-id</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M22"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">tuple-content-rules</xsl:attribute>
            <xsl:attribute name="name">tuple-content-rules</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M23"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">exclude-constraints</xsl:attribute>
            <xsl:attribute name="name">exclude-constraints</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M24"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">fraction-constraints</xsl:attribute>
            <xsl:attribute name="name">fraction-constraints</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M25"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">header-constraints</xsl:attribute>
            <xsl:attribute name="name">header-constraints</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M26"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">nonFraction-constraints</xsl:attribute>
            <xsl:attribute name="name">nonFraction-constraints</xsl:attribute>
            <xsl:apply-templates mode="ixbrl-schematron-main"/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M27"/>
      </svrl:schematron-output>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->
<xsl:param name="transform-registry" select="document('inlinexbrl-1_0-transformation.xsd')"/>

   <!--PATTERN unique-footnote-id-->


	<!--RULE -->
<xsl:template match="ix:footnote" priority="1000" mode="M7">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ix:footnote"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="1 eq count(//ix:footnote[@footnoteID eq current()/@footnoteID])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="1 eq count(//ix:footnote[@footnoteID eq current()/@footnoteID])">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
        &gt;For each ix:footnote element in the Inline XBRL Document Set there MUST NOT be any other ix:footnote element with the same {footnote id} property.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="ancestor-or-self::*/@xml:lang"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="ancestor-or-self::*/@xml:lang">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>The ix:footnote element MUST have an xml:lang attribute in scope.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M7"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M7"/>
   <xsl:template match="@*|node()" priority="-2" mode="M7">
      <xsl:apply-templates select="@*|*" mode="M7"/>
   </xsl:template>

   <!--PATTERN unique-id-->


	<!--RULE -->
<xsl:template match="ix:*[@id]" priority="1000" mode="M8">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ix:*[@id]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="1 eq count(//ix:*[@id eq current()/@id])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="1 eq count(//ix:*[@id eq current()/@id])">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>If the id attribute is present, the {id} property MUST NOT match the {id} property of any other element in the Inline XBRL Document Set.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M8"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M8"/>
   <xsl:template match="@*|node()" priority="-2" mode="M8">
      <xsl:apply-templates select="@*|*" mode="M8"/>
   </xsl:template>

   <!--PATTERN tuple-ref-->


	<!--RULE -->
<xsl:template match="ix:*[@tupleRef]" priority="1000" mode="M9">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ix:*[@tupleRef]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="//ix:tuple[@tupleID eq current()/@tupleRef]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="//ix:tuple[@tupleID eq current()/@tupleRef]">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>There MUST exist an ix:tuple element in the Inline XBRL Document Set with a {tuple id} property which has a value matching the {tuple reference} property.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M9"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M9"/>
   <xsl:template match="@*|node()" priority="-2" mode="M9">
      <xsl:apply-templates select="@*|*" mode="M9"/>
   </xsl:template>

   <!--PATTERN footnote-refs-->


	<!--RULE -->
<xsl:template match="ix:*[@footnoteRefs]" priority="1000" mode="M10">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ix:*[@footnoteRefs]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="every $footnoteID in tokenize(@footnoteRefs,' ') satisfies //ix:footnote[@footnoteID eq $footnoteID]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $footnoteID in tokenize(@footnoteRefs,' ') satisfies //ix:footnote[@footnoteID eq $footnoteID]">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>For each token in {footnote references} there MUST exist an ix:footnote element in the Inline XBRL Document Set with a {footnote id} property which has a matching value.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M10"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M10"/>
   <xsl:template match="@*|node()" priority="-2" mode="M10">
      <xsl:apply-templates select="@*|*" mode="M10"/>
   </xsl:template>

   <!--PATTERN context-ref-->


	<!--RULE -->
<xsl:template match="ix:*[@contextRef]" priority="1000" mode="M11">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ix:*[@contextRef]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="//xbrli:context[@id eq current()/@contextRef]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="//xbrli:context[@id eq current()/@contextRef]">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>There MUST exist an xbrli:context element in the Inline XBRL Document Set for which the actual value of the id attribute is equal to the {context reference} property.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M11"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M11"/>
   <xsl:template match="@*|node()" priority="-2" mode="M11">
      <xsl:apply-templates select="@*|*" mode="M11"/>
   </xsl:template>

   <!--PATTERN format-name-->


	<!--RULE -->
<xsl:template match="ix:*[@format]" priority="1000" mode="M12">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ix:*[@format]"/>
      <xsl:variable name="format" select="resolve-QName(@format, .)"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="$format eq xs:QName('ixt:datedoteu')                  or $format eq xs:QName('ixt:datedotus')                  or $format eq xs:QName('ixt:datelonguk')                  or $format eq xs:QName('ixt:datelongus')                  or $format eq xs:QName('ixt:dateshortuk')                  or $format eq xs:QName('ixt:dateshortus')                  or $format eq xs:QName('ixt:dateslasheu')                  or $format eq xs:QName('ixt:dateslashus')                  or $format eq xs:QName('ixt:numcomma')                  or $format eq xs:QName('ixt:numcommadot')                  or $format eq xs:QName('ixt:numdash')                  or $format eq xs:QName('ixt:numdotcomma')                  or $format eq xs:QName('ixt:numspacecomma')                  or $format eq xs:QName('ixt:numspacedot')                  "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$format eq xs:QName('ixt:datedoteu') or $format eq xs:QName('ixt:datedotus') or $format eq xs:QName('ixt:datelonguk') or $format eq xs:QName('ixt:datelongus') or $format eq xs:QName('ixt:dateshortuk') or $format eq xs:QName('ixt:dateshortus') or $format eq xs:QName('ixt:dateslasheu') or $format eq xs:QName('ixt:dateslashus') or $format eq xs:QName('ixt:numcomma') or $format eq xs:QName('ixt:numcommadot') or $format eq xs:QName('ixt:numdash') or $format eq xs:QName('ixt:numdotcomma') or $format eq xs:QName('ixt:numspacecomma') or $format eq xs:QName('ixt:numspacedot')">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>If the format attribute is present, the {format} property MUST match the expanded name implied by the value of the name attribute of a signature element in the relevant Transformation Rules Registry.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M12"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M12"/>
   <xsl:template match="@*|node()" priority="-2" mode="M12">
      <xsl:apply-templates select="@*|*" mode="M12"/>
   </xsl:template>

   <!--PATTERN formatted-value-->


	<!--RULE -->
<xsl:template match="ix:*[@format][not(@xsi:nil eq 'true')]" priority="1000" mode="M13">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ix:*[@format][not(@xsi:nil eq 'true')]"/>
      <xsl:variable name="format-local" select="if (contains(@format,':'))                                       then substring-after(@format,':')                                       else @format"/>
      <xsl:variable name="type-decl" select="$transform-registry/xs:schema/xs:simpleType[@name eq concat($format-local, 'Type')]"/>
      <xsl:variable name="regex" select="$type-decl/xs:restriction/(if (resolve-QName(@base, .) eq xs:QName('xs:string'))                                                                  then xs:pattern/@value                                                                  else (for $base-name in resolve-QName(@base, .) return /*/xs:simpleType[QName(/*/@targetNamespace, @name) eq $base-name])                                                                       /xs:restriction/xs:pattern/@value                                                                 )"/>
      <xsl:variable name="doc" select="$type-decl/xs:annotation/xs:documentation"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="$regex and matches(., concat('^', $regex, '$'))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$regex and matches(., concat('^', $regex, '$'))">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>If the format attribute is present, the {value} property MUST be valid in accordance with {format input type}: <xsl:text/>
                  <xsl:value-of select="@format"/>
                  <xsl:text/>: <xsl:text/>
                  <xsl:value-of select="$regex"/>
                  <xsl:text/>

                  <xsl:text/>
                  <xsl:value-of select="$doc"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M13"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M13"/>
   <xsl:template match="@*|node()" priority="-2" mode="M13">
      <xsl:apply-templates select="@*|*" mode="M13"/>
   </xsl:template>

   <!--PATTERN unit-ref-->


	<!--RULE -->
<xsl:template match="ix:*[@unitRef]" priority="1000" mode="M14">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ix:*[@unitRef]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="//xbrli:unit[@id eq current()/@unitRef]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="//xbrli:unit[@id eq current()/@unitRef]">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>There MUST exist an xbrli:unit element in the Inline XBRL Document Set for which the actual value of the id attribute is equal to the {unit reference} property.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M14"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M14"/>
   <xsl:template match="@*|node()" priority="-2" mode="M14">
      <xsl:apply-templates select="@*|*" mode="M14"/>
   </xsl:template>

   <!--PATTERN format-absent-->


	<!--RULE -->
<xsl:template match="*[self::ix:numerator                   or self::ix:denominator                   or self::ix:nonFraction]                     [not(@format)]                     [not(@xsi:nil eq 'true')]" priority="1000" mode="M15">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="*[self::ix:numerator                   or self::ix:denominator                   or self::ix:nonFraction]                     [not(@format)]                     [not(@xsi:nil eq 'true')]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="matches(normalize-space(.), '^\+?\d*\.?\d*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="matches(normalize-space(.), '^\+?\d*\.?\d*$')">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>If the format attribute is not present, the {value} property MUST be a non-negative number.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M15"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M15"/>
   <xsl:template match="@*|node()" priority="-2" mode="M15">
      <xsl:apply-templates select="@*|*" mode="M15"/>
   </xsl:template>

   <!--PATTERN header-count-->


	<!--RULE -->
<xsl:template match="/" priority="1000" mode="M16">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="/"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(//ix:header) ge 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(//ix:header) ge 1">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>There MUST be at least one ix:header element in the Inline XBRL Document Set.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M16"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M16"/>
   <xsl:template match="@*|node()" priority="-2" mode="M16">
      <xsl:apply-templates select="@*|*" mode="M16"/>
   </xsl:template>

   <!--PATTERN references-for-each-target-->


	<!--RULE -->
<xsl:template match="/" priority="1000" mode="M17">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="/"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="every $target in distinct-values(//*[ self::ix:fraction                                                         | self::ix:nonFraction                                                         | self::ix:nonNumeric                                                         | self::ix:tuple]/string(@target)                                                     ) satisfies //ix:references[string(@target) eq $target]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $target in distinct-values(//*[ self::ix:fraction | self::ix:nonFraction | self::ix:nonNumeric | self::ix:tuple]/string(@target) ) satisfies //ix:references[string(@target) eq $target]">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>There MUST be at least one ix:references element in the Inline XBRL Document Set for each Target Document.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M17"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M17"/>
   <xsl:template match="@*|node()" priority="-2" mode="M17">
      <xsl:apply-templates select="@*|*" mode="M17"/>
   </xsl:template>

   <!--PATTERN resources-count-->


	<!--RULE -->
<xsl:template match="/" priority="1000" mode="M18">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="/"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(//ix:resources) ge 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(//ix:resources) ge 1">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>There MUST be at least one ix:resources element in the Inline XBRL Document Set.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M18"/>
   <xsl:template match="@*|node()" priority="-2" mode="M18">
      <xsl:apply-templates select="@*|*" mode="M18"/>
   </xsl:template>

   <!--PATTERN unique-context-id-->


	<!--RULE -->
<xsl:template match="xbrli:context" priority="1000" mode="M19">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="xbrli:context"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="1 eq count(//xbrli:context[@id eq current()/@id])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="1 eq count(//xbrli:context[@id eq current()/@id])">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>For each xbrli:context element in the Inline XBRL Document Set there MUST NOT be any other element in the Inline XBRL Document Set with the same actual value for its id attribute, if any.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M19"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M19"/>
   <xsl:template match="@*|node()" priority="-2" mode="M19">
      <xsl:apply-templates select="@*|*" mode="M19"/>
   </xsl:template>

   <!--PATTERN unique-unit-id-->


	<!--RULE -->
<xsl:template match="xbrli:unit" priority="1000" mode="M20">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="xbrli:unit"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="1 eq count(//xbrli:unit[@id eq current()/@id])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="1 eq count(//xbrli:unit[@id eq current()/@id])">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>For each xbrli:unit element in the Inline XBRL Document Set there MUST NOT be any other element in the Inline XBRL Document Set with the same actual value for its id attribute, if any.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M20"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M20"/>
   <xsl:template match="@*|node()" priority="-2" mode="M20">
      <xsl:apply-templates select="@*|*" mode="M20"/>
   </xsl:template>

   <!--PATTERN order-attribute-->


	<!--RULE -->
<xsl:template match="ix:*[@order]" priority="1001" mode="M21">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ix:*[@order]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="@tupleRef or ancestor::ix:tuple"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@tupleRef or ancestor::ix:tuple">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>All elements MUST have an order attribute if and only if they are members of {tuple content}.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M21"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[self::ix:fraction                   or self::ix:nonFraction                   or self::ix:nonNumeric                   or self::ix:tuple] [not(@order)]" priority="1000" mode="M21">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="*[self::ix:fraction                   or self::ix:nonFraction                   or self::ix:nonNumeric                   or self::ix:tuple] [not(@order)]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(@tupleRef or ancestor::ix:tuple)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@tupleRef or ancestor::ix:tuple)">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>All elements MUST have an order attribute if and only if they are members of {tuple content}.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M21"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M21"/>
   <xsl:template match="@*|node()" priority="-2" mode="M21">
      <xsl:apply-templates select="@*|*" mode="M21"/>
   </xsl:template>

   <!--PATTERN unique-tuple-id-->


	<!--RULE -->
<xsl:template match="ix:tuple[@tupleID]" priority="1000" mode="M22">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ix:tuple[@tupleID]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="1 eq count(//ix:tuple[@tupleID eq current()/@tupleID])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="1 eq count(//ix:tuple[@tupleID eq current()/@tupleID])">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>For each ix:tuple element in the Inline XBRL Document Set there MUST NOT be any other ix:tuple element with the same {tuple id} property.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M22"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M22"/>
   <xsl:template match="@*|node()" priority="-2" mode="M22">
      <xsl:apply-templates select="@*|*" mode="M22"/>
   </xsl:template>

   <!--PATTERN tuple-content-rules-->


	<!--RULE -->
<xsl:template match="ix:tuple[not(@xsi:nil eq 'true')]" priority="1000" mode="M23">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ix:tuple[not(@xsi:nil eq 'true')]"/>
      <xsl:variable name="inline-content" select="( .//ix:fraction                                         | .//ix:nonFraction                                         | .//ix:nonNumeric                                         | .//ix:tuple                                         ) [not(@tupleRef)]                                           [ancestor::ix:*[1] is current()]"/>
      <xsl:variable name="tuple-content" select="$inline-content | //ix:*[@tupleRef eq current()/@tupleID]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count($tuple-content) ge 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count($tuple-content) ge 1">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>There MUST be at least one element in {tuple content}.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(@tupleRef = ( @tupleID                                     | .//ix:tuple/@tupleID                                     | $tuple-content/@tupleID                                     )                        )"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@tupleRef = ( @tupleID | .//ix:tuple/@tupleID | $tuple-content/@tupleID ) )">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>The ix:tuple element MUST NOT directly or recursively form part of the {tuple content} property of any ix:tuple element in {tuple content}.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count($tuple-content/@order) eq count(distinct-values($tuple-content/@order))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count($tuple-content/@order) eq count(distinct-values($tuple-content/@order))">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>The values of all the order attributes amongst elements in {tuple content} MUST be unique.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="$inline-content or @tupleID"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$inline-content or @tupleID">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>The element MUST either have one or more ix:fraction, ix:nonFraction, ix:nonNumeric or ix:tuple children, or have an tupleID atttribute.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="every $fact in $tuple-content satisfies string($fact/@target) eq string(current()/@target)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $fact in $tuple-content satisfies string($fact/@target) eq string(current()/@target)">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>The {target} property of the ix:tuple element MUST be equal to the {target} property of all elements in {tuple content}.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M23"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M23"/>
   <xsl:template match="@*|node()" priority="-2" mode="M23">
      <xsl:apply-templates select="@*|*" mode="M23"/>
   </xsl:template>

   <!--PATTERN exclude-constraints-->


	<!--RULE -->
<xsl:template match="ix:exclude" priority="1000" mode="M24">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ix:exclude"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="ancestor::ix:nonNumeric"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="ancestor::ix:nonNumeric">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>The ix:exclude element MUST be a descendant of an ix:nonNumeric element.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M24"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M24"/>
   <xsl:template match="@*|node()" priority="-2" mode="M24">
      <xsl:apply-templates select="@*|*" mode="M24"/>
   </xsl:template>

   <!--PATTERN fraction-constraints-->


	<!--RULE -->
<xsl:template match="ix:fraction[not(@xsi:nil eq 'true')]" priority="1000" mode="M25">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ix:fraction[not(@xsi:nil eq 'true')]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(.//ix:numerator)   = 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(.//ix:numerator) = 1">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>The ix:fraction element MUST have exactly one ix:numerator descendant element.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(.//ix:denominator) = 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(.//ix:denominator) = 1">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>The ix:fraction element MUST have exactly one ix:denominator descendant element.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M25"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M25"/>
   <xsl:template match="@*|node()" priority="-2" mode="M25">
      <xsl:apply-templates select="@*|*" mode="M25"/>
   </xsl:template>

   <!--PATTERN header-constraints-->


	<!--RULE -->
<xsl:template match="ix:header" priority="1000" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ix:header"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(ancestor::xhtml:head)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(ancestor::xhtml:head)">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>The ix:header element MUST NOT be a descendant of an HTML head element.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M26"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M26"/>
   <xsl:template match="@*|node()" priority="-2" mode="M26">
      <xsl:apply-templates select="@*|*" mode="M26"/>
   </xsl:template>

   <!--PATTERN nonFraction-constraints-->


	<!--RULE -->
<xsl:template match="ix:nonFraction" priority="1000" mode="M27">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ix:nonFraction"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="1 eq count( @decimals                               | @precision                               | @xsi:nil[. eq 'true']                               )"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="1 eq count( @decimals | @precision | @xsi:nil[. eq 'true'] )">
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>The ix:nonFraction element MUST have exactly one of: a decimals attribute; or a precision attribute; or have an xsi:nil attribute with the value true.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*" mode="M27"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M27"/>
   <xsl:template match="@*|node()" priority="-2" mode="M27">
      <xsl:apply-templates select="@*|*" mode="M27"/>
   </xsl:template>
<xsl:template match="/"><xsl:apply-templates mode="ixbrl-schematron-main" select="."/></xsl:template></xsl:stylesheet>