
Ext.namespace('Ext.ux.grid'); // create Ext.ux.grid namespace

// custom RowNumberer for use with paging GridPanels
Ext.ux.grid.PagingRowNumberer = Ext.extend(Ext.grid.RowNumberer, {
    renderer : function(v, p, record, rowIndex, colIndex, store){
        if (this.rowspan) {
            p.cellAttr = 'rowspan="' + this.rowspan + '"';
        }

        var so = store.lastOptions;
        var sop = so? so.params : null;
        return ((sop && sop.start)? sop.start : 0) + rowIndex + 1;
    }
});

Ext.onReady(function() {
    // Ext.data.JsonReaderオブジェクトの生成
    var reader = new Ext.data.JsonReader({
        totalProperty: 'totalCount',  // 全体件数を持つプロパティ名
        root: 'result',               // 行データの配列を持つプロパティ名
        fields: [                     // 各フィールドの設定
        {
            name: 'data_id',
            type: 'number'
        },
        {
            name: 'value',
            type: 'string'
        }
        ]
    });

    // Ext.data.Storeオブジェクトの生成
    var store = new Ext.data.Store({
        proxy: new Ext.data.ScriptTagProxy({
            url: 'http://localhost:9393/list.json' // $ shotgun grid-sinatra.rb
        }),
        reader:     reader,
        remoteSort: true,
        sortInfo: {
            field:     'data_id',
            direction: 'ASC'
        }
    });

    // Ext.PagingToolbarオブジェクトの生成
    var pagingToolBar = new Ext.PagingToolbar({
        pageSize:    10,  // 1ページに表示する件数
        store:       store,   // 使用されるデータ
        displayInfo: true,
        displayMsg:  '{2} 件中 の {0} 件から {1} 件までを表示しています。',
        emptyMsg:    '表示できるデータがありません。'
    });

    // Ext.grid.GridPanelオブジェクトの生成
    var grid = new Ext.grid.GridPanel({
        store: store,   // 表示するデータ
        columns: [      // 各列の設定
        new Ext.ux.grid.PagingRowNumberer({
            header: 'No.',
            width:  40
        }),
        //new Ext.grid.RowNumberer({
        //    header:'No.',
        //    width:40
        //}),
        {
            header:    'ID',
            width:     60,
            align:     'right',
            sortable:  true,
            id:        'data-id',
            dataIndex: 'data_id'
        },
        {
            header:    'Value',
            sortable:  true,
            id:        'value',
            dataIndex: 'value'
        }
        ],
        autoExpandColumn: 'value',
        stripeRows:       true,
        // width:         800,     // グリッドの幅
        height:           300,       // グリッドの高さ
        title:            'データ一覧',  // グリッドのタイトル
        renderTo:         'gridcontainer',
        bbar:             pagingToolBar
    });

    store.load({
        params: {
            start: 0,
            limit: 10
        }
    });  // データの読み込み
});
