
const SLIDER_X = 10;
const SLIDER_Y = 12;
const SLIDER_W = 20;
const SLIDER_UNIT = 10;  // １目盛り分の高さ
const SLIDER_H = (18 * SLIDER_UNIT);
const MXS = 0; // マウス座標補正
const SLIDER_BAR_COL = '#F00'; // スライダーのポインターの色

// スライダーの目盛りの文字位置(x)
const SCALE_TEXT_X = 40;
// スライダーの目盛りの文字列
const SCALE_TEXT = [
'10', '9', '8', '7', '6', '5', '4', '3', '2', '1',
'0.9', '0.8', '0.7', '0.6', '0.5', '0.4', '0.3', '0.2', '0.1'];

var barR;  // スライダーのポインター　横線
var barC;  // スライダーのポインター　円

var SLIDER_ORIGIN_Y = (SLIDER_Y + SLIDER_UNIT * 0.5 * (SCALE_TEXT.length - 1));
var ROOT_SLIDER; // スライダーのコンテナ
var current_scale = 1.0;
var current_pos = 0;  // 目盛り 1.0 の位置を 0 としたときの目盛り値

//===================================
function draw_scale_slider(paper, root, draw_handler) {

    ROOT_SLIDER = root;

    paper.rect(SLIDER_X, SLIDER_Y, SLIDER_W, SLIDER_H).attr({
        fill: '#AAA'
    });
    for (var i = 0; i < SCALE_TEXT.length; i++) {
        paper.path(Raphael.format('M {0},{1} l {2},0',
            SLIDER_X, (SLIDER_Y + SLIDER_UNIT * i), SLIDER_W));
        paper.text(SCALE_TEXT_X, i * SLIDER_UNIT + SLIDER_X, SCALE_TEXT[i]);
    }

    barB = paper.rect(0, 0, SLIDER_W, 2).attr({
        'stroke': SLIDER_BAR_COL,
        'translation': SLIDER_X + ',' + SLIDER_ORIGIN_Y
    });

    barC = paper.circle(0, 0, 6, 6).attr({
        'fill': SLIDER_BAR_COL,
        'translation': SLIDER_X + ',' + SLIDER_ORIGIN_Y
    });
    // スライダーのポインターの要素 (移動させる要素)の配列
    var slider_objs = new Array();
    slider_objs[0] = barB;
    slider_objs[1] = barC;

    // マウスイベント取得エリア
    var r0 = paper.rect(SLIDER_X, SLIDER_Y, SLIDER_W, SLIDER_H).attr({
        opacity: 0.2,
        fill: '#00F',
        cursor: 'crosshair'
    });

    // マウスイベントの処理
    r0.click(scale_slider_handler);
    r0.drag(
        function(dx, dy, x1, y1) {// move
            var b = ROOT_SLIDER.getBoundingClientRect();
            var y = y1 - b.top + MXS;
            if (y < SLIDER_Y) y = SLIDER_Y;
            if (y > SLIDER_Y + SLIDER_H) y = SLIDER_Y + SLIDER_H;

            var pos = y - slider_objs[0].attrs['y'];
            slider_objs[0].translate(0, pos);
            slider_objs[1].translate(0, pos);

            var z = SLIDER_ORIGIN_Y - y;
            var scale;
            if (z <= 0) {
                scale = 1.0 + 0.1 * z / SLIDER_UNIT;
            } else {
                scale = 1.0 + 1.0 * z / SLIDER_UNIT;
            }
            slider_handler_num(scale, false, 0);
            current_pos = pos;
        },
        function() {// start
            barC.ox = barC.cx;
            barC.oy = barC.cy;
        },
        function() {// end
        }
        );

    function scale_slider_handler(event) {
        var b = ROOT_SLIDER.getBoundingClientRect();
        var y = event.clientY - b.top + MXS;
        var pos = y - slider_objs[0].attrs['y'];
        slider_objs[0].translate(0, pos);
        slider_objs[1].translate(0, pos);

        var z = SLIDER_ORIGIN_Y - y;
        var scale;
        var speed = 200 + 100.0 * (Math.abs(pos - current_pos) / SLIDER_UNIT);
        if (z <= 0) {
            scale = 1.0 + 0.1 * (z / SLIDER_UNIT);
        } else {
            scale = 1.0 + 1.0 * (z / SLIDER_UNIT);
        }
        slider_handler_num(scale, true, speed);
        current_pos = pos;
    }

    function slider_handler_num(scale, is_animate, speed) {
        draw_handler(current_scale, scale, is_animate, speed);
        current_scale = scale;
        show_scale();
    }
}
//==========================
