var hira2roma = new MYAPP.katoy.typing.hira2roma();

var str = '' +
'ぁあぃいぅうぇえぉおかがきぎくぐけげこごさざしじすずせぜそぞただちぢっつづてでとど' +
'なにぬねのはばぱひびぴふぶぷへべぺほぼぽまみむめもゃやゅゆょよらりるれろゎわゐゑをん' +
'ァアィイゥウェエォオカガキギクグケゲコゴサザシジスズセゼソゾタダチヂッツヅテデトド' +
'ナニヌネノハバパヒビピフブプヘベペホボポマミムメモャヤュユョヨラリルレロヮワヰヱヲンヴヵヶ' +
'1234567890' +
'abcdefghijklmnopqrstuvwxyz' +
'ABCDEFGHIJKLMNOPQRSTUVWXYZ';

var to_hira_str = '' +
'ぁあぃいぅうぇえぉおかがきぎくぐけげこごさざしじすずせぜそぞただちぢっつづてでとど' +
'なにぬねのはばぱひびぴふぶぷへべぺほぼぽまみむめもゃやゅゆょよらりるれろゎわゐゑをん' +
'ぁあぃいぅうぇえぉおかがきぎくぐけげこごさざしじすずせぜそぞただちぢっつづてでとど' +
'なにぬねのはばぱひびぴふぶぷへべぺほぼぽまみむめもゃやゅゆょよらりるれろゎわゐゑをんヴヵヶ' +
'1234567890' +
'abcdefghijklmnopqrstuvwxyz' +
'ABCDEFGHIJKLMNOPQRSTUVWXYZ';

var to_kana_str = '' +
'ァアィイゥウェエォオカガキギクグケゲコゴサザシジスズセゼソゾタダチヂッツヅテデトド' +
'ナニヌネノハバパヒビピフブプヘベペホボポマミムメモャヤュユョヨラリルレロヮワヰヱヲン' +
'ァアィイゥウェエォオカガキギクグケゲコゴサザシジスズセゼソゾタダチヂッツヅテデトド' +
'ナニヌネノハバパヒビピフブプヘベペホボポマミムメモャヤュユョヨラリルレロヮワヰヱヲンヴヵヶ' +
'1234567890' +
'abcdefghijklmnopqrstuvwxyz' +
'ABCDEFGHIJKLMNOPQRSTUVWXYZ';

var to_roma_str = '' +
'A:A,  I:I,       U:U,      E:E,  O:O,' +
'KA:KA, KI:KI,      KU:KU,     KE:KE, KO:KO,' +
'SA:SA, SI:SI|SHI,  SU:SU,     SE:SE, SO:SO,' +
'TA:TA, TI:TI|CHI,  TU:TU|TSU, TE:TE, TO:TO,' +
'NA:NA, NI:NI,      NU:NU,     NE:NE, NO:NO,' +
'HA:HA, HI:HI,      HU:HU|FU,  HE:HE, HO:HO,' +
'MA:MA, MI:MI,      MU:MU,     ME:ME, MO:MO,' +
'YA:YA,             YU:YU,           YO:YO,' +
'RA:RA, RI:RI,      RU:RU,     RE:RE, RO:RO,' +
'WA:WA, WYI:WYI,                WUE:WUE,WO:WO,' +
'NN:NN|N\',GA:GA, GI:GI,    GU:GU, GE:GE, GO:GO,' +
'ZA:ZA, ZI:ZI|JI, ZU:ZU, ZE:ZE, ZO:ZO,' +
'DA:DA, DI:DI,    DU:DU, DE:DE, DO:DO,' +
'BA:BA, BI:BI,    BU:BU, BE:BE, BO:BO,' +
'PA:PA, PI:PI,    PU:PU, PE:PE, PO:PO,' +
'-:-|-,XA:XA,  XI:XI,  XU:XU,  XE:XE, XO:XO,' +
'XKA:XKA, XKE:XKE,' +
'XTU:XTU|XTSU,' +
'XYA:XYA, XYU:XYU, XYU:XYU, XWA:XWA,' +
'KYA:KYA, KYU:KYU, KYE:KYE, KYO:KYO,' +
'GYA:GYA, GYU:GYU, GYO:GYO,' +
'SYA:SYA|SHA, SYU:SYU|SHU, SYE:SYE|SHE, SYO:SYO|SHO,' +
'ZYA:ZYA|JA|JYA,  ZYU:ZYU|JU|JYU,  ZYE:ZYE|JE,  ZYO:ZYO|JO|JYO,' +
'TYA:TYA|CHA|CYA, TYU:TYU|CHU|CYU, TYE:TYE|CHE, TYO:TYO|CHO|CYO,' +
'DYA:DYA, DYU:DYU, DYO:DYO,NYA:NYA, NYU:NYU, NYO:NYO,' +
'HYA:HYA, HYU:HYU, HYO:HYO,BYA:BYA, BYU:BYU, HYO:BYO,' +
'HYA:HYA, HYU:HYU, HYO:HYO,MYA:MYA, MYU:MYU, MYO:MYO,' +
'RYA:RYA, RYU:RYU, RYO:RYO,TSA:TSA, TSE:TSE, TSO:TSO,' +
'THI:THI|T\'I, DHI:DHI|D\'I, THU:THU|T\'YU, DHU:DHU|D\'YU,' +
'FA:FA|HWA, FI:FI|HWI, FYU:FYU|HWYU, FE:FE|HWE, FO:FO|HWO,' +
'YE:YE,WHI:WHI|WI, WHE:WHE|WE, WHO:WHO,' +
'VA:VA, VI:VI, VU:VU, VE:VE, VO:VO,' +
'VYU:VYU,' +
'KWA:KWA|QA, KWI:KWI|QI, KWE:KWE|QE, KWO:KWO|QO,' +
'GWA:GWA,TSI:TSI,TWU:TWU|T\'U, DWU:DWU|D\'U';

var roma_to_hira_str = '' +
'あ:あ,  い:い,       う:う,      え:え,  お:お,' +
'か:か, き:き,      く:く,     け:け, こ:こ,' +
'さ:さ, し:し|し,  す:す,     せ:せ, そ:そ,' +
'た:た, ち:ち|ち,  つ:つ|つ, て:て, と:と,' +
'な:な, に:に,      ぬ:ぬ,     ね:ね, の:の,' +
'は:は, ひ:ひ,      ふ:ふ|ふ,  へ:へ, ほ:ほ,' +
'ま:ま, み:み,      む:む,     め:め, も:も,' +
'や:や,             ゆ:ゆ,           よ:よ,' +
'ら:ら, り:り,      る:る,     れ:れ, ろ:ろ,' +
'わ:わ, ゐ:ゐ,                ゑ:ゑ,を:を,' +
'ん:ん|ん,が:が, ぎ:ぎ,    ぐ:ぐ, げ:げ, ご:ご,' +
'ざ:ざ, じ:じ|じ, ず:ず, ぜ:ぜ, ぞ:ぞ,' +
'だ:だ, ぢ:ぢ,    づ:づ, で:で, ど:ど,' +
'ば:ば, び:び,    ぶ:ぶ, べ:べ, ぼ:ぼ,' +
'ぱ:ぱ, ぴ:ぴ,    ぷ:ぷ, ぺ:ぺ, ぽ:ぽ,' +
'ー:ー|ー,' +
'ぁ:ぁ,  ぃ:ぃ,  ぅ:ぅ,  ぇ:ぇ, ぉ:ぉ,' +
'ヵ:ヵ, ヶ:ヶ,' +
'っ:っ|っ,' +
'ゃ:ゃ, ょ:ょ, ょ:ょ, ゎ:ゎ,' +
'きゃ:きゃ, きゅ:きゅ, きぇ:きぇ, きょ:きょ,' +
'ぎゃ:ぎゃ, ぎゅ:ぎゅ, ぎょ:ぎょ,' +
'しゃ:しゃ|しゃ, しゅ:しゅ|しゅ, しぇ:しぇ|しぇ, しょ:しょ|しょ,' +
'じゃ:じゃ|じゃ|じゃ,  じゅ:じゅ|じゅ|じゅ,  じぇ:じぇ|じぇ,  じょ:じょ|じょ|じょ,' +
'ちゃ:ちゃ|ちゃ|ちゃ, ちゅ:ちゅ|ちゅ|ちゅ, ちぇ:ちぇ|ちぇ, ちょ:ちょ|ちょ|ちょ,' +
'ぢゃ:ぢゃ, ぢゅ:ぢゅ, ぢょ:ぢょ,' +
'にゃ:にゃ, にゅ:にゅ, にょ:にょ,' +
'ぴゃ:ぴゃ, ぴゅ:ぴゅ, ぴょ:ぴょ,' +
'びゃ:びゃ, びゅ:びゅ, ぴょ:ぴょ,' +
'ぴゃ:ぴゃ, ぴゅ:ぴゅ, ぴょ:ぴょ,' +
'みゃ:みゃ, みゅ:みゅ, みょ:みょ,' +
'りゃ:りゃ, りゅ:りゅ, りょ:りょ,' +
'つぁ:つぁ, つぇ:つぇ, つぉ:つぉ,' +
'てぃ:てぃ|てぃ, でぃ:でぃ|でぃ, てゅ:てゅ|てゅ, でゅ:でゅ|でゅ,' +
'ふぁ:ふぁ|ふぁ, ふぃ:ふぃ|ふぃ, ふゅ:ふゅ|ふゅ, ふぇ:ふぇ|ふぇ, ふぉ:ふぉ|ふぉ,' +
'いぇ:いぇ,うぃ:うぃ|うぃ, うぇ:うぇ|うぇ, うぉ:うぉ,' +
'ヴぁ:ヴぁ, ヴぃ:ヴぃ, ヴ:ヴ, ヴぇ:ヴぇ, ヴぉ:ヴぉ,' +
'ヴゅ:ヴゅ,' +
'くぁ:くぁ|くぁ, くぃ:くぃ|くぃ, くぇ:くぇ|くぇ, くぉ:くぉ|くぉ,' +
'ぐぁ:ぐぁ,つぃ:つぃ,とぅ:とぅ|とぅ, どぅ:どぅ|どぅ';

var h2r_table = '' +
'あ:a,  い:i,       う:u,      え:e,  お:o,' +
'か:ka, き:ki,      く:ku,     け:ke, こ:ko,' +
'さ:sa, し:si|shi,  す:su,     せ:se, そ:so,' +
'た:ta, ち:ti|chi,  つ:tu|tsu, て:te, と:to,' +
'な:na, に:ni,      ぬ:nu,     ね:ne, の:no,' +
'は:ha, ひ:hi,      ふ:hu|fu,  へ:he, ほ:ho,' +
'ま:ma, み:mi,      む:mu,     め:me, も:mo,' +
'や:ya,             ゆ:yu,           よ:yo,' +
'ら:ra, り:ri,      る:ru,     れ:re, ろ:ro,' +
'わ:wa, ゐ:wyi,                ゑ:wue,を:wo,' +
'ん:nn|n\',' +
'が:ga, ぎ:gi,    ぐ:gu, げ:ge, ご:go,' +
'ざ:za, じ:zi|ji, ず:zu, ぜ:ze, ぞ:zo,' +
'だ:da, ぢ:di,    づ:du, で:de, ど:do,' +
'ば:ba, び:bi,    ぶ:bu, べ:be, ぼ:bo,' +
'ぱ:pa, ぴ:pi,    ぷ:pu, ぺ:pe, ぽ:po,' +
'ー:-|-,' +
'ぁ:xa,  ぃ:xi,  ぅ:xu,  ぇ:xe, ぉ:xo,' +
'ヵ:xka, ヶ:xke,' +
'っ:xtu|xtsu,' +
'ゃ:xya, ゅ:xyu, ょ:xyu, ゎ:xwa,' +
'きゃ:kya, きゅ:kyu, きぇ:kye, きょ:kyo,' +
'ぎゃ:gya, ぎゅ:gyu, ぎょ:gyo,' +
'しゃ:sya|sha, しゅ:syu|shu, しぇ:sye|she, しょ:syo|sho,' +
'じゃ:zya|ja|jya,  じゅ:zyu|ju|jyu,  じぇ:zye|je,  じょ:zyo|jo|jyo,' +
'ちゃ:tya|cha|cya, ちゅ:tyu|chu|cyu, ちぇ:tye|che, ちょ:tyo|cho|cyo,' +
'ぢゃ:dya, ぢゅ:dyu, ぢょ:dyo,' +
'にゃ:nya, にゅ:nyu, にょ:nyo,' +
'ひゃ:hya, ひゅ:hyu, ひょ:hyo,' +
'びゃ:bya, びゅ:byu, ぴょ:byo,' +
'ぴゃ:hya, ぴゅ:hyu, ぴょ:hyo,' +
'みゃ:mya, みゅ:myu, みょ:myo,' +
'りゃ:rya, りゅ:ryu, りょ:ryo,' +
'つぁ:tsa, つぇ:tse, つぉ:tso,' +
'てぃ:thi|t\'i, でぃ:dhi|d\'i, てゅ:thu|t\'yu, でゅ:dhu|d\'yu,' +
'ふぁ:fa|hwa, ふぃ:fi|hwi, ふゅ:fyu|hwyu, ふぇ:fe|hwe, ふぉ:fo|hwo,' +
'いぇ:ye,' +
'うぃ:whi|wi, うぇ:whe|we, うぉ:who,' +
'ヴぁ:va, ヴぃ:vi, ヴ:vu, ヴぇ:ve, ヴぉ:vo,' +
'ヴゅ:vyu,' +
'くぁ:kwa|qa, くぃ:kwi|qi, くぇ:kwe|qe, くぉ:kwo|qo,' +
'ぐぁ:gwa,' +
'つぃ:tsi,' +
'とぅ:twu|t\'u, どぅ:dwu|d\'u';

$(document).ready(function(){

    // テストコード

    module("hira2roma");
    test("001", function() {

        // カタカナ -> ひらがなのチェック
        var to_str = hira2roma.kana_to_hira(str);
        equals(to_hira_str, to_str);

        // ひらがな -> カタカナのチェック
        to_str = hira2roma.hira_to_kana(str);
        equals(to_kana_str, to_str);

        // ひらがな -> ローマ字のチェック
        to_str = hira2roma.to_roma(h2r_table);
        equals(to_roma_str, to_str);

        // ローマ字 -> ひらがなのチェック
        var to_str2 = hira2roma.to_hira(to_str);
        equals(roma_to_hira_str, to_str2);

        expect( 4 ); // テスト総数
    });
// テストコード終了
});