
// See
//   - http://asquare.net/javascript/tests/KeyCode.html
//   　　onLKey イベントの挙動を調べることができる。
//
// TODO:
//    - リアルキーボードの キー押下の処理が不完全。
//      例： [@], [-], Shift + キー, CAPSLOCK キー, ....

var keytop = new MYAPP.katoy.vkey2.keytops();

$(function() {

    keytop.set_keytops(false, false, false);

    var $write = $('#write'),
    shift = false,
    capslock = false,
    kana = false,
    caret_pos = 0;

    // See http://asquare.net/javascript/tests/KeyCode.html
    //     JavaScript Event KeyCode Test Page

    document.onkeydown = function(e) {
        var ctrl,
        keycode,
        keychar;

        // Mozilla(Firefox, NN) and Opera
        if (e !== null) {
            keycode = e.which;
            ctrl = typeof e.modifiers === 'undefined' ? e.ctrlKey : e.modifiers & Event.CONTROL_MASK;
            shift = typeof e.modifiers === 'undefined' ? e.shiftKey : e.modifiers & Event.SHIFT_MASK;
            // イベントの上位伝播を防止
            e.preventDefault();
            e.stopPropagation();
        // Internet Explorer
        } else {
            keycode = event.keyCode;
            ctrl = event.ctrlKey;
            shift = event.shiftKey;
            // イベントの上位伝播を防止
            event.returnValue = false;
            event.cancelBubble = true;
        }

        // キーコードの文字を取得
        keychar = String.fromCharCode(keycode).toUpperCase();

        // Ctrl同時押しの場合
        if (ctrl) {
            keychar = 'Ctrl+' + keychar;
        // Shift同時押しの場合
        } else if (shift) {
            keychar = 'Shift+' + keychar;
        // 通常のキーダウン時の場合
        } else {
        // 特殊キーコードの対応については次を参照
        // - http://www.programming-magic.com/file/20080205232140/keycode_table.html
        // - http://javascriptist.net/docs/pract_keyboard_event.html
        // 27   Esc
        // 8    BackSpace
        // 9    Tab
        // 32   Space
        // 45   Insert
        // 46   Delete
        // 35   End
        // 36   Home
        // 33   PageUp
        // 34   PageDown
        // 38   ↑
        // 40   ↓
        // 37   ←
        // 39   →
        // 処理の例
        // if (keycode == 27) {
        //     alert('Escapeキーが押されました');
        // }
        }
        $('#keycode').html(keycode);
        $('#keychar').html(keychar);

        var caret_pos = keytop.getCaretPosition($write.get(0));
        if (keycode == 8) {
            // Back Space
            keytop.deleteTextBeforPosision($write.get(0), caret_pos);
        } else if (keycode == 46) {
            // Delete
            keytop.deleteTextAtPosision($write.get(0), caret_pos);
        } else if ((37 <= keycode) && (keycode <= 40)) {
            // Arrow 37:left, 38:up, 39:right, 40:down
            keytop.moveCaretPosition($write.get(0), keycode - 37);
        } else {
            var character = keytop.get_charactor(keycode, shift, capslock, kana);
            if ((!ctrl) && (character !== '')) {
                keytop.insertTextAtPosision($write.get(0), caret_pos, character);
            }
        }
    };

    $('#keyboard li').click(function() {

        var $this = $(this),
        character = '',
        sp_key = '';

        // Shift keys
        if ($this.hasClass('left-shift') || $this.hasClass('right-shift')) {
            shift = (shift === true) ? false : true;
            keytop.set_keytops(shift, capslock, kana);
            return false;
        }

        // Kana
        if ($this.hasClass('kana')) {
            kana = true;
            keytop.set_keytops(shift, capslock, kana);
            return false;
        }
        // 無変換
        if ($this.hasClass('muhenkan')) {
            kana = false;
            keytop.set_keytops(shift, capslock, kana);
            return false;
        }

        // Caps lock
        if ($this.hasClass('capslock')) {
            capslock = (capslock === true) ? false : true;
            $(this).toggleClass('shifton');

            keytop.set_keytops(shift, capslock, kana);
            return false;
        }

        // Backspace
        if ($this.hasClass('backspace')) {
            // var html = $write.html();
            // $write.html(html.substr(0, html.length - 1));
            caret_pos = keytop.getCaretPosition($write.get(0));
            keytop.deleteTextBeforPosision($write.get(0), caret_pos);
            return false;
        }
        // Delete
        if ($this.hasClass('delete')) {
            caret_pos = keytop.getCaretPosition($write.get(0));
            keytop.deleteTextAtPosision($write.get(0), caret_pos);
            return false;
        }
        // arrow-left
        if ($this.hasClass('arrow-left')) {
            keytop.moveCaretPosition($write.get(0), 0);
            return false;
        }
        // arrow-up
        if ($this.hasClass('arrow-up')) {
            keytop.moveCaretPosition($write.get(0), 1);
            return false;
        }
        // arrow-right
        if ($this.hasClass('arrow-right')) {
            keytop.moveCaretPosition($write.get(0), 2);
            return false;
        }
        // arrow-down
        if ($this.hasClass('arrow-down')) {
            keytop.moveCaretPosition($write.get(0), 3);
            return false;
        }

        if ($this.hasClass('letter')) {
            character = $($this).html();
        } else if ($this.hasClass('symbol')) {
            character = $($this).html();
        // Special characters
        } else if ($this.hasClass('space')) {
            character = ' ';
        } else if ($this.hasClass('tab')) {
            character = '\t';
        } else if ($this.hasClass('return0')) {
            character = '\n';
        } else if ($this.hasClass('return')) {
            character = '\n';
        } else {
            sp_key = this.id;
            character = '';
        //if ($this.hasClass('function')) character = "[" + character + "]";
        //if ($this.hasClass('ctrl')) character = [" + character + "]";
        //if ($this.hasClass('alt')) character = [" + character + "]";
        //if ($this.hasClass('muhenkan')) character = "[" + character + "]";
        //if ($this.hasClass('henkan')) character = "[" + character + "]";
        //if ($this.hasClass('kana')) character = "[" + character + "]";
        }

        $('#softkey_special').html(sp_key);

        // Remove shift once a key is clicked.
        if (shift === true) {
            shift = false;
            keytop.set_keytops(shift, capslock, kana);
        }

        // Add the character
        //$write.html($write.html() + character);
        caret_pos = keytop.getCaretPosition($write.get(0));
        keytop.insertTextAtPosision($write.get(0), caret_pos, character);
    });
});
