
# yahoo ファイナンスの株価データページから企業の証券取引所一覧を作成する。
#
# 2009-09-26 katoy

require 'rubygems'
require 'Yahoo_finance'
require 'benchmark'
require 'pp'

$KCODE = "utf8"

# 企業一覧データを読み込む。                                                                                            
def load_categorylist
  obj = nil
  File.open( "cprofile/categorylist.yaml" ) { |io|
    YAML.load_documents(io) do |y|
      obj = y
    end
  }
  obj
end

puts Benchmark.measure {
  market = {}
  num = 0
  list = load_categorylist
  list.each do |k,v|
    v[:list].each do |data|
      company = data[0]
      num += 1

      sleep 2 if num % 10 == 0
      info = Yahoo_finance.new(company)
      market[company] = info.get_market

      pp "#{num}: #{company}: #{market[company]}"
    end
  end

  open("charts/marketlist.yaml", "w") { |f|
    f.write market.ya2yaml
  }

}
