
# MSN ファイナンスの株価データページから財務諸表の情報を得る。
#  usage: ruby finance05.rb company_code
#
# 2009-09-12 katoy
# 2009-09-13 katoy

require 'rubygems'
require 'pp'
require 'benchmark'

require 'Msn_finance'

$KCODE = "utf8"

def usage
  puts "usage:"
  puts "  $ ruby #{$0} company_code"
  puts "  commpany_code: 企業コード"
  puts "     See: http://jp.moneycentral.msn.com/investor/common/find.aspx"
  puts "     例: 'JP:7974'  // 任天堂"
  puts "         'JP:7203'  // トヨタ自動車"
  puts "         'JP:6758'  // ソニー"
  exit
end

GRAPH_KIDS = {
  # 8: "売上高合計", 19: "営業利益" "27: "税引後利益 "
  :Income => [ 
    {:index => '売上高合計', :color =>'0000ff'},
    { :index => '営業利益', :color =>'4b0082'},
    { :index => '税引後利益', :color =>'ff6347'}
  ],
  :Balance => [],
  :CashFlow => [],
}

usage if ARGV.size == 0

COMPANY = ARGV[0]

puts Benchmark.measure { 
  info = Msn_finance.new(COMPANY)
  info.show(GRAPH_KIDS)

  pp info.graph[:Income][:title]
  puts info.graph[:Income][:g][:big].to_url_x
  puts info.graph[:Income][:g][:small].to_url_x
  # info.save_yaml(:verify => true)

  puts info.path
  # info.data.each_with_index { |v, i| p "#{i}: #{v.keys}" } 
  # pp info.graph[:plot][0]
  # pp info.graph[:plot][1]
}
