// See

Ext.BLANK_IMAGE_URL = 'ext-3.0.0/resources/images/default/s.gif';

Ext.onReady(function() {

  // Ext.data.JsonReaderオブジェクトの生成
  var reader = new Ext.data.JsonReader({
    totalProperty : 'totalCount',
    root: "data",  // 行データの配列を持つプロパティ名
    fields: [      // 各フィールドの設定
      {name: "sic", type: "int"},
      {name: "industry", type: "string"},
      {name: "office", type: "int"}
    ],
    remoteSort    : true
  });

  // Ext.data.Storeオブジェクトの生成
  var store = new Ext.data.Store({
    proxy: new Ext.data.HttpProxy({url: "/app/sic.json", method: "GET"}),
    reader: reader
  });

  // Ext.grid.GridPanelオブジェクトの生成
  var grid = new Ext.grid.GridPanel({
    store: store,   // 表示するデータ
    columns: [      // 各列の設定
      {header: "SIC", width: 80, sortable: true, dataIndex: "sic"},
      {header: "industry", width: 420, sortable: true, dataIndex: "industry"},
      {header: "office", width: 80, sortable: true, dataIndex: "office"}
    ],
    width: 600,     // グリッドの幅
    height: 300,    // グリッドの高さ
    title: "SIC 一覧",  // グリッドのタイトル
    stripeRows: true,

    // paging bar on the bottom
    bbar: new Ext.PagingToolbar({
        pageSize: 20,
        store: store,
        displayInfo: true,
        displayMsg: 'Displaying topics {0} - {1} of {2}',
        emptyMsg: "No topics to display",
        items:[
            '-', {
            pressed: true,
            enableToggle:true,
            text: 'Show Preview',
            cls: 'x-btn-text-icon details',
            toggleHandler: function(btn, pressed){
                var view = grid.getView();
                view.showPreview = pressed;
                view.refresh();
            }
        }]
    }),

	plugins: [
	],
    renderTo: "grid"
  });
  //
  // データの読み込み
  // store.load( {params : {start : 0, limit : 50}});
  store.load();
});
