/*
 * See http://ja.doukaku.org/246/lang/scala/
 */

package scalaapplication

object DivCalc extends Application {
    val n = Console.in.readLine.toLong
    val m = Console.in.readLine.toLong
    Div(n, m).print
}

case class Div(n: Long, m: Long) {

    val ans: Long = n / m
    def len(a: Any) = a.toString.length
    def fmt(x: Any) :String = fmt(x, 0)
    def fmt(x: Any, i:Int): String = idt(" ", len(n) - len(x) - i) + x
    def line = idt("-", len(n))
    def idt: String = idt(" ", len(m) + 1)
    def idt(c: String, i: Int): String = c * i

    lazy val mod: Long = n % m
    lazy val calc: List[(Long, Long, Int)] = {
        def process(n: Long, m: Long, c: Int):List[(Long, Long, Int)] = {
            val pow = Math.pow(10, c).toLong
            val x = if (pow == 0) { 0L } else { n / pow / m * m }
            (n, m, c, x) match {
                case (_, _, c ,_) if (c < 0) => Nil
                case (n, m, c, 0) => process(n, m, c-1)
                case (n, m, c, x) => (n / pow, x, c) :: process(n - x * pow, m, c-1)
            }
        }
        process(n, m, len(n))
    }

    def print() = {
        println( idt + fmt(ans) )
        println( idt + line )
        println( m + ")" + fmt(n) )
        calc.take(1).foreach( x => println( idt + fmt(x._2, x._3) ) )
        calc.drop(1).foreach( x => {
                println( idt + line )
                println( idt + fmt(x._1, x._3) )
                println( idt + fmt(x._2, x._3) )
            })
        if (calc.isEmpty) println( idt + fmt(0) )
        println( idt + line )
        println( idt + fmt(mod) )
    }
}

