require 'rubygems'
require 'fastercsv'
require 'kconv'
require 'benchmark'
require 'pp'

$KCODE="utf8"

# 00: 科目分類
# 01: 標準ラベル（日本語）
# 02: 冗長ラベル（日本語）
# 03: 用途別ラベル（日本語）
# 04: 業種ラベル（日本語）
# 05: 連結
# 06: 四半期個別
# 07: 四半期連結
# 08: 中間個別
# 09: 中間連結
# 10: 標準ラベル（英語）
# 11: 用途別ラベル（英語）
# 12: 業種ラベル（英語）
# 13: 名前空間プレフィックス
# 14: 要素名
# 15: 優先ラベル

class Csv2Pdic
  attr_reader :pdic

  def initialize
    @pdic = { }
  end

  def add_using_csv(csvFile)
    rows = FasterCSV.read(csvFile)
    rows.each do |row|
      # 01: 標準ラベル（日本語）, 02: 冗長ラベル（日本語）, 03: 用途別ラベル（日本語）, 04: 業種ラベル（日本語）, # 14: 要素名
      val = [row[1], row[2], row[3], row[4], row[14]]
      add_data( row[10], val) # 10: 標準ラベル（英語）
      add_data( row[11], val) # 11: 用途別ラベル（英語）
      add_data( row[12], val) # 12: 業種ラベル（英語）
      add_data( row[14], val) # 14: 要素名

      # 10: 標準ラベル（英語）, 11: 用途別ラベル（英語）, 12: 業種ラベル（英語）, 14: 要素名
      val = [row[10], row[11], row[12], row[14]]
      add_data( row[1], val) # 01: 標準ラベル（日本語）
      add_data( row[2], val) # 02: 冗長ラベル（日本語）
      add_data( row[3], val) # 03: 用途別ラベル（日本語）
      add_data( row[4], val) # 04: 業種ラベル（日本語）
    end
  end

  def add_data(key, val)
    return if key == nil or key == ''

    data = { }
    # １セルに複数行で記載されているケースに対応する
    key.split(/[$,、]/).each do |k|
      data[k.strip] = val
    end
    
    @pdic.merge!(data) { |key, self_val, other_val|
      self_val.concat(other_val).uniq
    }
  end
end

puts Benchmark.measure {  

  csv2pdic = Csv2Pdic.new
  Dir.glob('../edinet-2009-03-01/*.csv').each do |f|
    csv2pdic.add_using_csv(f)
  end

#  pp csv2pdic.pdic["Balance at the end of current period[期末]"]

  File.open('edinet-2009-03-01.txt', 'w') do |file|
    pdic = csv2pdic.pdic
    pdic.keys.sort.each do |key|
      file.puts(key)
      file.puts("[]#{pdic[key].join(',').sub(/$/, ',')}")
    end
  end
}
