
# (/usr/bin/env ruby -Ku) // jruby で動作しなくなるので外す
# EDINET_CODE 情報を保持する。
# 2009-05-17 katoy
#

require 'rubygems'
require 'fastercsv'
require 'pp'

$KCODE="utf8"

EDINET_CODE_CSV = '../edinet-code/account_list-utf8.csv'
class EdinetCode
  attr_reader :info

  def initialize
    @info = {}
    rows = FasterCSV.read(EDINET_CODE_CSV)

    # "旧EDINETコード","新EDINETコード","新ファンドコード","備考","提出者名称","ファンド名称"
    rows.each { |row|
      data = {}
      data[:OLD_CODE] = row[0]
      data[:NEW_CODE] = row[1]
      data[:FUND_CODE] = row[2]
      data[:COMMENT] = row[3]
      data[:NAME] = row[4]
      data[:FUND_NAME] = row[5]
      @info[data[:NEW_CODE]] = data
    }
  end

  def self.get_code_from_path(path)
    # pfr-q3r-E02142-000-2008-12-31-01-2009-02-12
    match = path.scan(/(.*)\-(E.....)\-(.*)/)
    match[0][1]
  end
end

#--------- 呼び出し例 -----------
if __FILE__ == $0

  edinet_code = EdinetCode.new
  info = edinet_code.info
  #infos.each_key do |code|
  #  puts "#{code} #{infos[code][:NAME]}"
  #end

  code = EdinetCode::get_code_from_path('pfr-q3r-E02142-000-2008-12-31-01-2009-02-12')
  pp code
  pp info[code]
end
