
# MSN ファイナンスの株価データページから財務諸表の情報を得る。
#  usage: ruby finance05.rb company_code
#
# 2009-09-12 katoy
# 2009-09-23 katoy   cprofile/companylist.yaml の企業一覧を元にループするようにした。

require 'rubygems'
require 'pp'
require 'benchmark'

require 'Msn_finance'

$KCODE = "utf8"

def load_categorylist
  obj = nil
  File.open( "cprofile/categorylist.yaml" ) {  |io|
    YAML.load_documents(io) do |y|
      obj = y
    end
  }
  obj
end

puts Benchmark.measure { 
  clist = load_categorylist
  clist.each do |k, v|
    v[:list].keys.each do |id|

      next if File.exists?("data/#{id}.yaml")

      sleep 1
      begin
        info = Msn_finance.new("JP:#{id}", v[:cid], k)
        info.save_yaml(:verify => true)
        pp "#{id}: #{info.name}"
      rescue => e
        pp e
      end
    end
  end
}
