/*
 * Transformation.scala
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package ixbrl

object Transformation {

    // ixt:datedoteu	DD.MM.YY(YY)	YYYY-MM-DD
    // ixt:datedotus	MM.DD.YY(YY)	YYYY-MM-DD
    // ixt:datelonguk	DD Month YY(YY)	YYYY-MM-DD
    // ixt:datelongus	Month DD, YY(YY) YYYY-MM-DD
    // ixt:dateshortuk	DD Mon YY(YY)	YYYY-MM-DD
    // ixt:dateshortus 	Mon DD, YY(YY)	YYYY-MM-DD
    // ixt:dateslasheu 	DD/MM/YY(YY)	YYYY-MM-DD
    // ixt:dateslashus 	MM/DD/YY(YY)	YYYY-MM-DD
    //
    // ixt:numcomma	nnnnnnnnn,nn    nnnnnnnnn.nn
    // ixt:numcommadot	nnn,nnn,nnn.nn  nnnnnnnnn.nn
    // ixt:numdash      -               0
    // ixt:numdotcomma	nnn.nnn.nnn,nn  nnnnnnnnn.nn
    // ixt:numspacecomma nnn nnn nnn,nn nnnnnnnnn.nn
    // ixt:numspacedot	nnn nnn nnn.nn  nnnnnnnnn.nn

    val namePattern = """(.*):(.*)""".r
    def transform(form:String, str:String):String = {
        form match {
            case "ixt:datedoteu" => val pattern = """(..)\.(..)\.(.*)""".r
                str match {
                    case pattern(d,m,y) => String.format("%s-%s-%s", yy2year(y), m, d)
                    case _ => str
                }
            case "ixt:datedotus" => val pattern = """(..)\.(..)\.(.*)""".r
                str match {
                    case pattern(m,d,y) => String.format("%s-%s-%s", yy2year(y), m, d)
                    case _ => str
                }
            case "ixt:datelonguk" =>  val pattern = """(..) (.*) (.*)""".r
                str match {
                    case pattern(d,month,y) => String.format("%s-%s-%s", yy2year(y), month2mm(month), d)
                    case _ => str
                }
            case "ixt:datelongus" => val pattern = """(.*) (..),(.*)""".r
                str match {
                    case pattern(month,d,y) => String.format("%s-%s-%s", yy2year(y), month2mm(month), d)
                    case _ => str
                }
            case "ixt:dateshortuk" => val pattern = """(..) (.*) (.*)""".r
                str match {
                    case pattern(d,month,y) => String.format("%s-%s-%s", yy2year(y), month2mm(month), d)
                    case _ => str
                }
            case "ixt:dateshortus" => val pattern = """(.*) (..),(.*)""".r
                str match {
                    case pattern(month,d,y) => String.format("%s-%s-%s", yy2year(y), month2mm(month), d)
                    case _ => str
                }
            case "ixt:dateslasheu" => val pattern = """(..)/(..)/(.*)""".r
                str match {
                    case pattern(d,m,y) => String.format("%s-%s-%s", yy2year(y), m, d)
                    case _ => str
                }
            case "ixt:dateslashus" => val pattern = """(..)/(..)/(.*)""".r
                str match {
                    case pattern(m,d,y) => String.format("%s-%s-%s", yy2year(y), m, d)
                    case _ => str
                }
                //
            case "ixt:numcomma" => str.replaceFirst(",", ".")
            case "ixt:numcommadot" => str.replaceAll(",", "")
            case "ixt:numdash" => if (str == "-") "0" else str
            case "ixt:numdotcomma" => str.replaceAll("\\.", "").replaceFirst(",", ".")
            case "ixt:numspacecomma" => str.replaceAll(" ", "").replaceFirst(",", ".")
            case "ixt:numspacedot" => str.replaceAll(" ", "")
            case _ => str
        }
    }

    def yy2year(yy:String):String = {
        if (yy.length == 2) "20" + yy else yy
    }

    val monthList = Map("Jan"->"01", "Feb"->"02","Mar"->"03","Apr"->"04","May"->"05","Jun"->"06",
                        "Jul"->"07","Aug"->"08","Sep"->"09","Oct"->"10","Nov"->"11","Dec"->"12")
    def month2mm(month:String):String = {
        if (monthList.get(month.substring(0,3))!= null) monthList.get(month.substring(0,3)).get
        else month
    }

    //    def escapeStr(s:String):String = {
    //        val ans = new Queue[String]()
    //        s.foreach { c =>
    //            println("[" + c + "]")
    //            ans += (c match {
    //                    case '<' => "&lt;"
    //                    case '>' => "&gt;"
    //                    case '&' => "&amp;"
    //                    case _ => c.toString
    //                })
    //        }
    //        ans.mkString
    //    }
}
