
//
// See http://wiki.github.com/alaz/mongo-scala-driver/
//

package mongodb

import scala.io.Source
import com.mongodb._
import com.osinka.mongodb._
import com.osinka.mongodb.Preamble._
import com.osinka.mongodb.shape._

object searchZip2 {
    val DB_PORT = 27017
    val DB_NAME = "test"
    val COLLECTION_NAME = "zipcodes"

    def main(args: Array[String]) {

        val stat=System.nanoTime()
        action
        val end = System.nanoTime
        println("time(s):" + 1.0 * (end - stat) /(1000 * 1000 * 1000) )

    }

    def action():Unit = {

        val mongo = new Mongo("localhost", DB_PORT).getDB(DB_NAME)
        // Suppose we have a DBCollection:
        val dbColl = mongo.getCollection(COLLECTION_NAME)
        val zipcodes = dbColl.of(Zip)

        // Get first
        //val first: Option[Zip] = zipcodes.firstOption
        //println("========")
        //println(first.get.toString)

        // Get only first 2
        //println("========")
        //for (z <- Zip take 2 in zipcodes) { println(z.toString)}

        // Query by regexp
        println("========")
        for(z <- Zip.zip like "100000.".r in zipcodes) {println(z.toString)}
        // 13101,100  ,1000000,トウキョウト,チヨダク,イカニケイサイガナイバアイ,東京都,千代田区,以下に掲載がない場合,0,0,0,0,0,0
        // 13101,100  ,1000004,トウキョウト,チヨダク,オオテマチ(ツギノビルヲノゾク),東京都,千代田区,大手町（次のビルを除く）,0,0,1,0,0,0
        // 13101,100  ,1000002,トウキョウト,チヨダク,コウキョガイエン,東京都,千代田区,皇居外苑,0,0,0,0,0,0
        // 13101,100  ,1000001,トウキョウト,チヨダク,チヨダ,東京都,千代田区,千代田,0,0,0,0,0,0
        // 13101,100  ,1000003,トウキョウト,チヨダク,ヒトツバシ(1チョウメ),東京都,千代田区,一ツ橋（１丁目）,1,0,1,0,0,0
        // 13101,100  ,1000005,トウキョウト,チヨダク,マルノウチ(ツギノビルヲノゾク),東京都,千代田区,丸の内（次のビルを除く）,0,0,1,0,0,0
        // 13101,100  ,1000006,トウキョウト,チヨダク,ユウラクチョウ,東京都,千代田区,有楽町,0,0,1,0,0,0
        // time(s):1.702426

        // Query by regexp
        //val r = Zip.zip like "100000.".r in zipcodes
        //println("========")
        //for(p <- 0 to (r.size - 1)/2) {
        //    println("  page:" + (p + 1))
        //    for(z <- r.drop (p * 2) take 2) {
        //        println(z.toString)
        //    }
        //}

        // Query by where
        //println("========")
        //for (z <- (Zip where {Zip.zip is_== "1000001"} take 1 in zipcodes) ) {println(z.toString)}
    }
}
