/*
 * Copyright(C) 2007 Jiro Nishiguchi <jiro@cpan.org>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package senna;

/**
 * Wrapper for sen_records
 */
public class Records {

    /* C pointer to sen_records */
    private int ptr;

    /**
     * creates new records object.
     * 
     * @param ptr
     *            C pointer
     */
    Records(int ptr) {
        this.ptr = ptr;
    }

    /**
     * call sen_records_next().
     * 
     * @return next keys or null.
     */
    public native String next();

    /**
     * call sen_records_close().
     * 
     * @throws SennaException
     */
    public native void close() throws SennaException;

    /**
     * call sen_records_curr_score().
     * 
     * @return curr_score
     */
    public native int currScore();

    /**
     * call sen_records_curr_key().
     * 
     * @return curr_key
     */
    public native String currKey();

    /**
     * call sen_records_rewind().
     * 
     * @throws SennaException
     */
    public native void rewind() throws SennaException;

    /**
     * call sen_records_nhits().
     * 
     * @return nhits
     */
    public native int nhits();

    /**
     * call sen_records_find().
     * 
     * @param key
     *            key
     * @return score
     */
    public native int find(String key);

}
